/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import com.squareup.javapoet.ClassName;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.model.DerivedInstanceConfig;

public final class DerivedInstanceConfigs {
    private DerivedInstanceConfigs() {
    }

    public static DerivedInstanceConfig InstanceConfig(Optional<String> implSelector, Optional<ClassName> targetClass) {
        return new InstanceConfig(implSelector, targetClass);
    }

    public static DerivedInstanceConfig lazy(Supplier<DerivedInstanceConfig> derivedInstanceConfig) {
        return new Lazy(derivedInstanceConfig);
    }

    public static CasesMatchers.TotalMatcher_InstanceConfig cases() {
        return CasesMatchers.totalMatcher_InstanceConfig;
    }

    public static Optional<String> getImplSelector(DerivedInstanceConfig derivedInstanceConfig) {
        return derivedInstanceConfig.match((implSelector, targetClass) -> implSelector);
    }

    public static Optional<ClassName> getTargetClass(DerivedInstanceConfig derivedInstanceConfig) {
        return derivedInstanceConfig.match((implSelector, targetClass) -> targetClass);
    }

    public static Function<DerivedInstanceConfig, DerivedInstanceConfig> setImplSelector(Optional<String> newImplSelector) {
        return DerivedInstanceConfigs.modImplSelector(__ -> newImplSelector);
    }

    public static Function<DerivedInstanceConfig, DerivedInstanceConfig> modImplSelector(Function<Optional<String>, Optional<String>> implSelectorMod) {
        return derivedInstanceConfig -> derivedInstanceConfig.match((implSelector, targetClass) -> DerivedInstanceConfigs.InstanceConfig((Optional)implSelectorMod.apply(implSelector), targetClass));
    }

    public static Function<DerivedInstanceConfig, DerivedInstanceConfig> setTargetClass(Optional<ClassName> newTargetClass) {
        return DerivedInstanceConfigs.modTargetClass(__ -> newTargetClass);
    }

    public static Function<DerivedInstanceConfig, DerivedInstanceConfig> modTargetClass(Function<Optional<ClassName>, Optional<ClassName>> targetClassMod) {
        return derivedInstanceConfig -> derivedInstanceConfig.match((implSelector, targetClass) -> DerivedInstanceConfigs.InstanceConfig(implSelector, (Optional)targetClassMod.apply(targetClass)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_InstanceConfig totalMatcher_InstanceConfig = new TotalMatcher_InstanceConfig();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_InstanceConfig {
            TotalMatcher_InstanceConfig() {
            }

            public final <X> Function<DerivedInstanceConfig, X> InstanceConfig(DerivedInstanceConfig.Case<X> InstanceConfig2) {
                return derivedInstanceConfig -> derivedInstanceConfig.match(InstanceConfig2);
            }

            public final <X> Function<DerivedInstanceConfig, X> InstanceConfig_(X x) {
                return this.InstanceConfig((implSelector, targetClass) -> x);
            }
        }
    }

    private static final class Lazy
    extends DerivedInstanceConfig {
        private volatile Supplier<DerivedInstanceConfig> expression;
        private DerivedInstanceConfig evaluation;

        Lazy(Supplier<DerivedInstanceConfig> derivedInstanceConfig) {
            this.expression = derivedInstanceConfig;
        }

        private synchronized DerivedInstanceConfig _evaluate() {
            block2: {
                DerivedInstanceConfig eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DerivedInstanceConfig> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(DerivedInstanceConfig.Case<X> Case2) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(Case2);
        }

        @Override
        public boolean equals(Object obj) {
            return (this.expression == null ? this.evaluation : this._evaluate()).equals(obj);
        }

        @Override
        public int hashCode() {
            return (this.expression == null ? this.evaluation : this._evaluate()).hashCode();
        }

        @Override
        public String toString() {
            return (this.expression == null ? this.evaluation : this._evaluate()).toString();
        }
    }

    private static final class InstanceConfig
    extends DerivedInstanceConfig {
        private final Optional<String> implSelector;
        private final Optional<ClassName> targetClass;

        InstanceConfig(Optional<String> implSelector, Optional<ClassName> targetClass) {
            this.implSelector = implSelector;
            this.targetClass = targetClass;
        }

        @Override
        public <X> X match(DerivedInstanceConfig.Case<X> Case2) {
            return Case2.InstanceConfig(this.implSelector, this.targetClass);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DerivedInstanceConfig && ((DerivedInstanceConfig)obj).match((implSelector, targetClass) -> this.implSelector.equals(implSelector) && this.targetClass.equals(targetClass)) != false;
        }

        @Override
        public int hashCode() {
            return (23 + this.implSelector.hashCode()) * 23 + this.targetClass.hashCode();
        }

        @Override
        public String toString() {
            return "InstanceConfig(" + this.implSelector + ", " + this.targetClass + ")";
        }
    }
}

