/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import com.squareup.javapoet.ClassName;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.model.DeriveTargetClass;
import org.derive4j.processor.api.model.DeriveVisibility;

public final class DeriveTargetClasses {
    private DeriveTargetClasses() {
    }

    public static DeriveTargetClass TargetClass(ClassName className, DeriveVisibility visibility, Optional<ClassName> extend) {
        return new TargetClass(className, visibility, extend);
    }

    public static DeriveTargetClass lazy(Supplier<DeriveTargetClass> deriveTargetClass) {
        return new Lazy(deriveTargetClass);
    }

    public static CasesMatchers.TotalMatcher_TargetClass cases() {
        return CasesMatchers.totalMatcher_TargetClass;
    }

    public static ClassName getClassName(DeriveTargetClass deriveTargetClass) {
        return deriveTargetClass.match((className, visibility, extend) -> className);
    }

    public static DeriveVisibility getVisibility(DeriveTargetClass deriveTargetClass) {
        return deriveTargetClass.match((className, visibility, extend) -> visibility);
    }

    public static Optional<ClassName> getExtend(DeriveTargetClass deriveTargetClass) {
        return deriveTargetClass.match((className, visibility, extend) -> extend);
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> setClassName(ClassName newClassName) {
        return DeriveTargetClasses.modClassName(__ -> newClassName);
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> modClassName(Function<ClassName, ClassName> classNameMod) {
        return deriveTargetClass -> deriveTargetClass.match((className, visibility, extend) -> DeriveTargetClasses.TargetClass((ClassName)classNameMod.apply(className), visibility, extend));
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> setVisibility(DeriveVisibility newVisibility) {
        return DeriveTargetClasses.modVisibility(__ -> newVisibility);
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> modVisibility(Function<DeriveVisibility, DeriveVisibility> visibilityMod) {
        return deriveTargetClass -> deriveTargetClass.match((className, visibility, extend) -> DeriveTargetClasses.TargetClass(className, (DeriveVisibility)visibilityMod.apply(visibility), extend));
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> setExtend(Optional<ClassName> newExtend) {
        return DeriveTargetClasses.modExtend(__ -> newExtend);
    }

    public static Function<DeriveTargetClass, DeriveTargetClass> modExtend(Function<Optional<ClassName>, Optional<ClassName>> extendMod) {
        return deriveTargetClass -> deriveTargetClass.match((className, visibility, extend) -> DeriveTargetClasses.TargetClass(className, visibility, (Optional)extendMod.apply(extend)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_TargetClass totalMatcher_TargetClass = new TotalMatcher_TargetClass();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_TargetClass {
            TotalMatcher_TargetClass() {
            }

            public final <X> Function<DeriveTargetClass, X> TargetClass(DeriveTargetClass.Case<X> TargetClass2) {
                return deriveTargetClass -> deriveTargetClass.match(TargetClass2);
            }

            public final <X> Function<DeriveTargetClass, X> TargetClass_(X x) {
                return this.TargetClass((className, visibility, extend) -> x);
            }
        }
    }

    private static final class Lazy
    extends DeriveTargetClass {
        private volatile Supplier<DeriveTargetClass> expression;
        private DeriveTargetClass evaluation;

        Lazy(Supplier<DeriveTargetClass> deriveTargetClass) {
            this.expression = deriveTargetClass;
        }

        private synchronized DeriveTargetClass _evaluate() {
            block2: {
                DeriveTargetClass eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DeriveTargetClass> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(DeriveTargetClass.Case<X> Case2) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(Case2);
        }
    }

    private static final class TargetClass
    extends DeriveTargetClass {
        private final ClassName className;
        private final DeriveVisibility visibility;
        private final Optional<ClassName> extend;

        TargetClass(ClassName className, DeriveVisibility visibility, Optional<ClassName> extend) {
            this.className = className;
            this.visibility = visibility;
            this.extend = extend;
        }

        @Override
        public <X> X match(DeriveTargetClass.Case<X> Case2) {
            return Case2.TargetClass(this.className, this.visibility, this.extend);
        }
    }
}

