/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeVariable;
import org.derive4j.processor.api.model.DataArgument;
import org.derive4j.processor.api.model.DataConstructor;
import org.derive4j.processor.api.model.DataDeconstructor;
import org.derive4j.processor.api.model.TypeRestriction;

public final class DataConstructors {
    private DataConstructors() {
    }

    public static DataConstructor constructor(String name, int index, List<TypeVariable> typeVariables, List<DataArgument> arguments, List<TypeRestriction> typeRestrictions, DeclaredType returnedType, DataDeconstructor deconstructor) {
        return new Constructor(name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor);
    }

    public static DataConstructor lazy(Supplier<DataConstructor> dataConstructor) {
        return new Lazy(dataConstructor);
    }

    public static CasesMatchers.TotalMatcher_Constructor cases() {
        return CasesMatchers.totalMatcher_Constructor;
    }

    public static String getName(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> name);
    }

    public static int getIndex(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> index);
    }

    public static List<TypeVariable> getTypeVariables(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> typeVariables);
    }

    public static List<DataArgument> getArguments(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> arguments);
    }

    public static List<TypeRestriction> getTypeRestrictions(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> typeRestrictions);
    }

    public static DeclaredType getReturnedType(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> returnedType);
    }

    public static DataDeconstructor getDeconstructor(DataConstructor dataConstructor) {
        return dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> deconstructor);
    }

    public static Function<DataConstructor, DataConstructor> setName(String newName) {
        return DataConstructors.modName(__ -> newName);
    }

    public static Function<DataConstructor, DataConstructor> modName(Function<String, String> nameMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor((String)nameMod.apply(name), index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setIndex(Integer newIndex) {
        return DataConstructors.modIndex(__ -> newIndex);
    }

    public static Function<DataConstructor, DataConstructor> modIndex(Function<Integer, Integer> indexMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, (Integer)indexMod.apply(index), typeVariables, arguments, typeRestrictions, returnedType, deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setTypeVariables(List<TypeVariable> newTypeVariables) {
        return DataConstructors.modTypeVariables(__ -> newTypeVariables);
    }

    public static Function<DataConstructor, DataConstructor> modTypeVariables(Function<List<TypeVariable>, List<TypeVariable>> typeVariablesMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, index, (List)typeVariablesMod.apply(typeVariables), arguments, typeRestrictions, returnedType, deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setArguments(List<DataArgument> newArguments) {
        return DataConstructors.modArguments(__ -> newArguments);
    }

    public static Function<DataConstructor, DataConstructor> modArguments(Function<List<DataArgument>, List<DataArgument>> argumentsMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, index, typeVariables, (List)argumentsMod.apply(arguments), typeRestrictions, returnedType, deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setTypeRestrictions(List<TypeRestriction> newTypeRestrictions) {
        return DataConstructors.modTypeRestrictions(__ -> newTypeRestrictions);
    }

    public static Function<DataConstructor, DataConstructor> modTypeRestrictions(Function<List<TypeRestriction>, List<TypeRestriction>> typeRestrictionsMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, index, typeVariables, arguments, (List)typeRestrictionsMod.apply(typeRestrictions), returnedType, deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setReturnedType(DeclaredType newReturnedType) {
        return DataConstructors.modReturnedType(__ -> newReturnedType);
    }

    public static Function<DataConstructor, DataConstructor> modReturnedType(Function<DeclaredType, DeclaredType> returnedTypeMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, index, typeVariables, arguments, typeRestrictions, (DeclaredType)returnedTypeMod.apply(returnedType), deconstructor));
    }

    public static Function<DataConstructor, DataConstructor> setDeconstructor(DataDeconstructor newDeconstructor) {
        return DataConstructors.modDeconstructor(__ -> newDeconstructor);
    }

    public static Function<DataConstructor, DataConstructor> modDeconstructor(Function<DataDeconstructor, DataDeconstructor> deconstructorMod) {
        return dataConstructor -> dataConstructor.match((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> DataConstructors.constructor(name, index, typeVariables, arguments, typeRestrictions, returnedType, (DataDeconstructor)deconstructorMod.apply(deconstructor)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Constructor totalMatcher_Constructor = new TotalMatcher_Constructor();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Constructor {
            TotalMatcher_Constructor() {
            }

            public final <R> Function<DataConstructor, R> constructor(DataConstructor.Case<R> constructor) {
                return dataConstructor -> dataConstructor.match(constructor);
            }

            public final <R> Function<DataConstructor, R> constructor_(R r) {
                return this.constructor((name, index, typeVariables, arguments, typeRestrictions, returnedType, deconstructor) -> r);
            }
        }
    }

    private static final class Lazy
    extends DataConstructor {
        private volatile Supplier<DataConstructor> expression;
        private DataConstructor evaluation;

        Lazy(Supplier<DataConstructor> dataConstructor) {
            this.expression = dataConstructor;
        }

        private synchronized DataConstructor _evaluate() {
            block2: {
                DataConstructor eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DataConstructor> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(DataConstructor.Case<R> constructor) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(constructor);
        }
    }

    private static final class Constructor
    extends DataConstructor {
        private final String name;
        private final int index;
        private final List<TypeVariable> typeVariables;
        private final List<DataArgument> arguments;
        private final List<TypeRestriction> typeRestrictions;
        private final DeclaredType returnedType;
        private final DataDeconstructor deconstructor;

        Constructor(String name, int index, List<TypeVariable> typeVariables, List<DataArgument> arguments, List<TypeRestriction> typeRestrictions, DeclaredType returnedType, DataDeconstructor deconstructor) {
            this.name = name;
            this.index = index;
            this.typeVariables = typeVariables;
            this.arguments = arguments;
            this.typeRestrictions = typeRestrictions;
            this.returnedType = returnedType;
            this.deconstructor = deconstructor;
        }

        @Override
        public <R> R match(DataConstructor.Case<R> constructor) {
            return constructor.constructor(this.name, this.index, this.typeVariables, this.arguments, this.typeRestrictions, this.returnedType, this.deconstructor);
        }
    }
}

