/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.model.AlgebraicDataType;
import org.derive4j.processor.api.model.DataArgument;
import org.derive4j.processor.api.model.DataConstruction;
import org.derive4j.processor.api.model.DeriveConfig;
import org.derive4j.processor.api.model.MatchMethod;
import org.derive4j.processor.api.model.TypeConstructor;

public final class AlgebraicDataTypes {
    private AlgebraicDataTypes() {
    }

    public static AlgebraicDataType adt(DeriveConfig deriveConfig, TypeConstructor typeConstructor, MatchMethod matchMethod, DataConstruction dataConstruction, List<DataArgument> fields) {
        return new Adt(deriveConfig, typeConstructor, matchMethod, dataConstruction, fields);
    }

    public static AlgebraicDataType lazy(Supplier<AlgebraicDataType> algebraicDataType) {
        return new Lazy(algebraicDataType);
    }

    public static CasesMatchers.TotalMatcher_Adt cases() {
        return CasesMatchers.totalMatcher_Adt;
    }

    public static DeriveConfig getDeriveConfig(AlgebraicDataType algebraicDataType) {
        return algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> deriveConfig);
    }

    public static TypeConstructor getTypeConstructor(AlgebraicDataType algebraicDataType) {
        return algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> typeConstructor);
    }

    public static MatchMethod getMatchMethod(AlgebraicDataType algebraicDataType) {
        return algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> matchMethod);
    }

    public static DataConstruction getDataConstruction(AlgebraicDataType algebraicDataType) {
        return algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> dataConstruction);
    }

    public static List<DataArgument> getFields(AlgebraicDataType algebraicDataType) {
        return algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> fields);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> setDeriveConfig(DeriveConfig newDeriveConfig) {
        return AlgebraicDataTypes.modDeriveConfig(__ -> newDeriveConfig);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> modDeriveConfig(Function<DeriveConfig, DeriveConfig> deriveConfigMod) {
        return algebraicDataType -> algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> AlgebraicDataTypes.adt((DeriveConfig)deriveConfigMod.apply(deriveConfig), typeConstructor, matchMethod, dataConstruction, fields));
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> setTypeConstructor(TypeConstructor newTypeConstructor) {
        return AlgebraicDataTypes.modTypeConstructor(__ -> newTypeConstructor);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> modTypeConstructor(Function<TypeConstructor, TypeConstructor> typeConstructorMod) {
        return algebraicDataType -> algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> AlgebraicDataTypes.adt(deriveConfig, (TypeConstructor)typeConstructorMod.apply(typeConstructor), matchMethod, dataConstruction, fields));
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> setMatchMethod(MatchMethod newMatchMethod) {
        return AlgebraicDataTypes.modMatchMethod(__ -> newMatchMethod);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> modMatchMethod(Function<MatchMethod, MatchMethod> matchMethodMod) {
        return algebraicDataType -> algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> AlgebraicDataTypes.adt(deriveConfig, typeConstructor, (MatchMethod)matchMethodMod.apply(matchMethod), dataConstruction, fields));
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> setDataConstruction(DataConstruction newDataConstruction) {
        return AlgebraicDataTypes.modDataConstruction(__ -> newDataConstruction);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> modDataConstruction(Function<DataConstruction, DataConstruction> dataConstructionMod) {
        return algebraicDataType -> algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> AlgebraicDataTypes.adt(deriveConfig, typeConstructor, matchMethod, (DataConstruction)dataConstructionMod.apply(dataConstruction), fields));
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> setFields(List<DataArgument> newFields) {
        return AlgebraicDataTypes.modFields(__ -> newFields);
    }

    public static Function<AlgebraicDataType, AlgebraicDataType> modFields(Function<List<DataArgument>, List<DataArgument>> fieldsMod) {
        return algebraicDataType -> algebraicDataType.match((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> AlgebraicDataTypes.adt(deriveConfig, typeConstructor, matchMethod, dataConstruction, (List)fieldsMod.apply(fields)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Adt totalMatcher_Adt = new TotalMatcher_Adt();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Adt {
            TotalMatcher_Adt() {
            }

            public final <R> Function<AlgebraicDataType, R> adt(AlgebraicDataType.Case<R> adt) {
                return algebraicDataType -> algebraicDataType.match(adt);
            }

            public final <R> Function<AlgebraicDataType, R> adt_(R r) {
                return this.adt((deriveConfig, typeConstructor, matchMethod, dataConstruction, fields) -> r);
            }
        }
    }

    private static final class Lazy
    extends AlgebraicDataType {
        private volatile Supplier<AlgebraicDataType> expression;
        private AlgebraicDataType evaluation;

        Lazy(Supplier<AlgebraicDataType> algebraicDataType) {
            this.expression = algebraicDataType;
        }

        private synchronized AlgebraicDataType _evaluate() {
            block2: {
                AlgebraicDataType eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<AlgebraicDataType> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(AlgebraicDataType.Case<R> adt) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(adt);
        }
    }

    private static final class Adt
    extends AlgebraicDataType {
        private final DeriveConfig deriveConfig;
        private final TypeConstructor typeConstructor;
        private final MatchMethod matchMethod;
        private final DataConstruction dataConstruction;
        private final List<DataArgument> fields;

        Adt(DeriveConfig deriveConfig, TypeConstructor typeConstructor, MatchMethod matchMethod, DataConstruction dataConstruction, List<DataArgument> fields) {
            this.deriveConfig = deriveConfig;
            this.typeConstructor = typeConstructor;
            this.matchMethod = matchMethod;
            this.dataConstruction = dataConstruction;
            this.fields = fields;
        }

        @Override
        public <R> R match(AlgebraicDataType.Case<R> adt) {
            return adt.adt(this.deriveConfig, this.typeConstructor, this.matchMethod, this.dataConstruction, this.fields);
        }
    }
}

