/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.ClassName;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.TypeClassInstance;

public final class TypeClassInstances {
    private TypeClassInstances() {
    }

    public static TypeClassInstance instance(ClassName typeClass, ClassName typeConstructor) {
        return new Instance(typeClass, typeConstructor);
    }

    public static TypeClassInstance lazy(Supplier<TypeClassInstance> typeClassInstance) {
        return new Lazy(typeClassInstance);
    }

    public static CasesMatchers.TotalMatcher_Instance cases() {
        return CasesMatchers.totalMatcher_Instance;
    }

    public static ClassName getTypeClass(TypeClassInstance typeClassInstance) {
        return typeClassInstance.instance((typeClass, typeConstructor) -> typeClass);
    }

    public static ClassName getTypeConstructor(TypeClassInstance typeClassInstance) {
        return typeClassInstance.instance((typeClass, typeConstructor) -> typeConstructor);
    }

    public static Function<TypeClassInstance, TypeClassInstance> setTypeClass(ClassName newTypeClass) {
        return TypeClassInstances.modTypeClass(__ -> newTypeClass);
    }

    public static Function<TypeClassInstance, TypeClassInstance> modTypeClass(Function<ClassName, ClassName> typeClassMod) {
        return typeClassInstance -> typeClassInstance.instance((typeClass, typeConstructor) -> TypeClassInstances.instance((ClassName)typeClassMod.apply((ClassName)typeClass), typeConstructor));
    }

    public static Function<TypeClassInstance, TypeClassInstance> setTypeConstructor(ClassName newTypeConstructor) {
        return TypeClassInstances.modTypeConstructor(__ -> newTypeConstructor);
    }

    public static Function<TypeClassInstance, TypeClassInstance> modTypeConstructor(Function<ClassName, ClassName> typeConstructorMod) {
        return typeClassInstance -> typeClassInstance.instance((typeClass, typeConstructor) -> TypeClassInstances.instance(typeClass, (ClassName)typeConstructorMod.apply((ClassName)typeConstructor)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Instance totalMatcher_Instance = new TotalMatcher_Instance();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Instance {
            TotalMatcher_Instance() {
            }

            public final <X> Function<TypeClassInstance, X> instance(BiFunction<ClassName, ClassName, X> instance) {
                return typeClassInstance -> typeClassInstance.instance(instance);
            }

            public final <X> Function<TypeClassInstance, X> instance_(X x) {
                return this.instance((typeClass, typeConstructor) -> x);
            }
        }
    }

    private static final class Lazy
    extends TypeClassInstance {
        private volatile Supplier<TypeClassInstance> expression;
        private TypeClassInstance evaluation;

        Lazy(Supplier<TypeClassInstance> typeClassInstance) {
            this.expression = typeClassInstance;
        }

        private synchronized TypeClassInstance _evaluate() {
            block2: {
                TypeClassInstance eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<TypeClassInstance> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X instance(BiFunction<ClassName, ClassName, X> instance) {
            return (this.expression == null ? this.evaluation : this._evaluate()).instance(instance);
        }

        @Override
        public boolean equals(Object obj) {
            return (this.expression == null ? this.evaluation : this._evaluate()).equals(obj);
        }

        @Override
        public int hashCode() {
            return (this.expression == null ? this.evaluation : this._evaluate()).hashCode();
        }

        @Override
        public String toString() {
            return (this.expression == null ? this.evaluation : this._evaluate()).toString();
        }
    }

    private static final class Instance
    extends TypeClassInstance {
        private final ClassName typeClass;
        private final ClassName typeConstructor;

        Instance(ClassName typeClass, ClassName typeConstructor) {
            this.typeClass = typeClass;
            this.typeConstructor = typeConstructor;
        }

        @Override
        public <X> X instance(BiFunction<ClassName, ClassName, X> instance) {
            return instance.apply(this.typeClass, this.typeConstructor);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TypeClassInstance && ((TypeClassInstance)obj).instance((typeClass, typeConstructor) -> this.typeClass.equals(typeClass) && this.typeConstructor.equals(typeConstructor)) != false;
        }

        @Override
        public int hashCode() {
            return (23 + this.typeClass.hashCode()) * 23 + this.typeConstructor.hashCode();
        }

        @Override
        public String toString() {
            return "instance(" + this.typeClass + ", " + this.typeConstructor + ")";
        }
    }
}

