/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.ClassName;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.Derivator;
import org.derive4j.processor.api.DerivatorSelection;

public final class DerivatorSelections {
    private DerivatorSelections() {
    }

    public static DerivatorSelection selection(ClassName forClass, Derivator derivator) {
        return DerivatorSelection.selection(forClass, derivator);
    }

    public static DerivatorSelection selection(ClassName forClass, Optional<String> selector, Derivator derivator) {
        return new Selection(forClass, selector, derivator);
    }

    public static DerivatorSelection lazy(Supplier<DerivatorSelection> derivatorSelection) {
        return new Lazy(derivatorSelection);
    }

    public static CasesMatchers.TotalMatcher_Selection cases() {
        return CasesMatchers.totalMatcher_Selection;
    }

    public static ClassName getForClass(DerivatorSelection derivatorSelection) {
        return derivatorSelection.match((forClass, selector, derivator) -> forClass);
    }

    public static Optional<String> getSelector(DerivatorSelection derivatorSelection) {
        return derivatorSelection.match((forClass, selector, derivator) -> selector);
    }

    public static Derivator getDerivator(DerivatorSelection derivatorSelection) {
        return derivatorSelection.match((forClass, selector, derivator) -> derivator);
    }

    public static Function<DerivatorSelection, DerivatorSelection> setForClass(ClassName newForClass) {
        return DerivatorSelections.modForClass(__ -> newForClass);
    }

    public static Function<DerivatorSelection, DerivatorSelection> modForClass(Function<ClassName, ClassName> forClassMod) {
        return derivatorSelection -> derivatorSelection.match((forClass, selector, derivator) -> DerivatorSelections.selection((ClassName)forClassMod.apply(forClass), selector, derivator));
    }

    public static Function<DerivatorSelection, DerivatorSelection> setSelector(Optional<String> newSelector) {
        return DerivatorSelections.modSelector(__ -> newSelector);
    }

    public static Function<DerivatorSelection, DerivatorSelection> modSelector(Function<Optional<String>, Optional<String>> selectorMod) {
        return derivatorSelection -> derivatorSelection.match((forClass, selector, derivator) -> DerivatorSelections.selection(forClass, (Optional)selectorMod.apply(selector), derivator));
    }

    public static Function<DerivatorSelection, DerivatorSelection> setDerivator(Derivator newDerivator) {
        return DerivatorSelections.modDerivator(__ -> newDerivator);
    }

    public static Function<DerivatorSelection, DerivatorSelection> modDerivator(Function<Derivator, Derivator> derivatorMod) {
        return derivatorSelection -> derivatorSelection.match((forClass, selector, derivator) -> DerivatorSelections.selection(forClass, selector, (Derivator)derivatorMod.apply(derivator)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Selection totalMatcher_Selection = new TotalMatcher_Selection();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Selection {
            TotalMatcher_Selection() {
            }

            public final <X> Function<DerivatorSelection, X> selection(DerivatorSelection.Case<X> selection) {
                return derivatorSelection -> derivatorSelection.match(selection);
            }

            public final <X> Function<DerivatorSelection, X> selection_(X x) {
                return this.selection((forClass, selector, derivator) -> x);
            }
        }
    }

    private static final class Lazy
    extends DerivatorSelection {
        private volatile Supplier<DerivatorSelection> expression;
        private DerivatorSelection evaluation;

        Lazy(Supplier<DerivatorSelection> derivatorSelection) {
            this.expression = derivatorSelection;
        }

        private synchronized DerivatorSelection _evaluate() {
            block2: {
                DerivatorSelection eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DerivatorSelection> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(DerivatorSelection.Case<X> selection) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(selection);
        }
    }

    private static final class Selection
    extends DerivatorSelection {
        private final ClassName forClass;
        private final Optional<String> selector;
        private final Derivator derivator;

        Selection(ClassName forClass, Optional<String> selector, Derivator derivator) {
            this.forClass = forClass;
            this.selector = selector;
            this.derivator = derivator;
        }

        @Override
        public <X> X match(DerivatorSelection.Case<X> selection) {
            return selection.selection(this.forClass, this.selector, this.derivator);
        }
    }
}

