/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.BoundExpression;
import org.derive4j.processor.api.FreeVariable;
import org.derive4j.processor.api.model.Expression;

public final class BoundExpressions {
    private BoundExpressions() {
    }

    public static BoundExpression expression(List<FreeVariable> freeVariables, Expression expression) {
        return new Expression_(freeVariables, expression);
    }

    public static BoundExpression lazy(Supplier<BoundExpression> boundExpression) {
        return new Lazy(boundExpression);
    }

    public static CasesMatchers.TotalMatcher_Expression cases() {
        return CasesMatchers.totalMatcher_Expression;
    }

    public static List<FreeVariable> getFreeVariables(BoundExpression boundExpression) {
        return boundExpression.expression((freeVariables, expression) -> freeVariables);
    }

    public static Expression getExpression(BoundExpression boundExpression) {
        return boundExpression.expression((freeVariables, expression) -> expression);
    }

    public static Function<BoundExpression, BoundExpression> setFreeVariables(List<FreeVariable> newFreeVariables) {
        return BoundExpressions.modFreeVariables(__ -> newFreeVariables);
    }

    public static Function<BoundExpression, BoundExpression> modFreeVariables(Function<List<FreeVariable>, List<FreeVariable>> freeVariablesMod) {
        return boundExpression -> boundExpression.expression((freeVariables, expression) -> BoundExpressions.expression((List)freeVariablesMod.apply((List<FreeVariable>)freeVariables), expression));
    }

    public static Function<BoundExpression, BoundExpression> setExpression(Expression newExpression) {
        return BoundExpressions.modExpression(__ -> newExpression);
    }

    public static Function<BoundExpression, BoundExpression> modExpression(Function<Expression, Expression> expressionMod) {
        return boundExpression -> boundExpression.expression((freeVariables, expression) -> BoundExpressions.expression(freeVariables, (Expression)expressionMod.apply((Expression)expression)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Expression totalMatcher_Expression = new TotalMatcher_Expression();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Expression {
            TotalMatcher_Expression() {
            }

            public final <X> Function<BoundExpression, X> expression(BiFunction<List<FreeVariable>, Expression, X> expression) {
                return boundExpression -> boundExpression.expression(expression);
            }

            public final <X> Function<BoundExpression, X> expression_(X x) {
                return this.expression((freeVariables, expression) -> x);
            }
        }
    }

    private static final class Lazy
    extends BoundExpression {
        private volatile Supplier<BoundExpression> expression;
        private BoundExpression evaluation;

        Lazy(Supplier<BoundExpression> boundExpression) {
            this.expression = boundExpression;
        }

        private synchronized BoundExpression _evaluate() {
            block2: {
                BoundExpression eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<BoundExpression> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X expression(BiFunction<List<FreeVariable>, Expression, X> expression) {
            return (this.expression == null ? this.evaluation : this._evaluate()).expression(expression);
        }
    }

    private static final class Expression_
    extends BoundExpression {
        private final List<FreeVariable> freeVariables;
        private final Expression expression;

        Expression_(List<FreeVariable> freeVariables, Expression expression) {
            this.freeVariables = freeVariables;
            this.expression = expression;
        }

        @Override
        public <X> X expression(BiFunction<List<FreeVariable>, Expression, X> expression) {
            return expression.apply(this.freeVariables, this.expression);
        }
    }
}

