/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.Binding;
import org.derive4j.processor.api.FreeVariable;
import org.derive4j.processor.api.model.Expression;

public final class Bindings {
    private Bindings() {
    }

    public static Binding binding(FreeVariable variable, Expression value) {
        return new Binding_(variable, value);
    }

    public static Binding lazy(Supplier<Binding> binding) {
        return new Lazy(binding);
    }

    public static CasesMatchers.TotalMatcher_Binding cases() {
        return CasesMatchers.totalMatcher_Binding;
    }

    public static FreeVariable getVariable(Binding binding) {
        return binding.binding((variable, value) -> variable);
    }

    public static Expression getValue(Binding binding) {
        return binding.binding((variable, value) -> value);
    }

    public static Function<Binding, Binding> setVariable(FreeVariable newVariable) {
        return Bindings.modVariable(__ -> newVariable);
    }

    public static Function<Binding, Binding> modVariable(Function<FreeVariable, FreeVariable> variableMod) {
        return binding -> binding.binding((variable, value) -> Bindings.binding((FreeVariable)variableMod.apply(variable), value));
    }

    public static Function<Binding, Binding> setValue(Expression newValue) {
        return Bindings.modValue(__ -> newValue);
    }

    public static Function<Binding, Binding> modValue(Function<Expression, Expression> valueMod) {
        return binding -> binding.binding((variable, value) -> Bindings.binding(variable, (Expression)valueMod.apply(value)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Binding totalMatcher_Binding = new TotalMatcher_Binding();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Binding {
            TotalMatcher_Binding() {
            }

            public final <X> Function<Binding, X> binding(Binding.Case<X> binding) {
                return binding_ -> binding_.binding(binding);
            }

            public final <X> Function<Binding, X> binding_(X x) {
                return this.binding((variable, value) -> x);
            }
        }
    }

    private static final class Lazy
    extends Binding {
        private volatile Supplier<Binding> expression;
        private Binding evaluation;

        Lazy(Supplier<Binding> binding) {
            this.expression = binding;
        }

        private synchronized Binding _evaluate() {
            block2: {
                Binding eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<Binding> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X binding(Binding.Case<X> binding) {
            return (this.expression == null ? this.evaluation : this._evaluate()).binding(binding);
        }
    }

    private static final class Binding_
    extends Binding {
        private final FreeVariable variable;
        private final Expression value;

        Binding_(FreeVariable variable, Expression value) {
            this.variable = variable;
            this.value = value;
        }

        @Override
        public <X> X binding(Binding.Case<X> binding) {
            return binding.binding(this.variable, this.value);
        }
    }
}

