/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.type.TypePair;
import org.delia.valuebuilder.DValueBuilder;

public class StructValueBuilder
extends DValueBuilder {
    private DStructType structType;
    public Map<String, DValue> map = new TreeMap<String, DValue>();
    public List<TypePair> allFields;

    public StructValueBuilder(DStructType type) {
        if (!type.isShape(Shape.STRUCT)) {
            this.addWrongTypeError("expecting struct");
            return;
        }
        this.type = type;
        this.structType = type;
        this.allFields = type.getAllFields();
    }

    @Override
    public void buildFromString(String input) {
    }

    public void addField(String fieldName, DValue dval) {
        this.addField(fieldName, dval, true);
    }

    public void addField(String fieldName, DValue dval, boolean logNullErr) {
        if (fieldName == null || fieldName.isEmpty()) {
            this.addNoDataError("null or empty fieldname");
            return;
        }
        if (fieldName.contains(".")) {
            this.addNoDataError("struct field names cannot contain '.'");
        }
        boolean isOptional = this.structType.fieldIsOptional(fieldName);
        if (dval == null && !isOptional) {
            if (logNullErr) {
                this.addNoDataError("null field value");
            }
            return;
        }
        if (this.map.containsKey(fieldName)) {
            this.addDuplicateFieldError(String.format("already added field '%s'", fieldName), fieldName);
            return;
        }
        if (!this.isValidFieldName(fieldName)) {
            this.addUnknownFieldError(String.format("fieldName not allowed: '%s'", fieldName));
            return;
        }
        TypePair pair = this.fieldExists(fieldName);
        if (pair == null) {
            this.addUnknownFieldError(String.format("unknown field '%s'", fieldName));
            return;
        }
        DType target = pair.type;
        boolean isRelation = target.isStructShape();
        if (!(isRelation || isOptional || target.isAssignmentCompatible(dval.getType()))) {
            this.addWrongTypeError(String.format("field %s", fieldName));
        }
        this.map.put(fieldName, dval);
    }

    private TypePair fieldExists(String targetFieldName) {
        for (TypePair pair : this.allFields) {
            if (!pair.name.equals(targetFieldName)) continue;
            return pair;
        }
        return null;
    }

    private boolean isValidFieldName(String fieldName) {
        for (int i = 0; i < fieldName.length(); ++i) {
            char ch = fieldName.charAt(i);
            if (Character.isWhitespace(ch)) {
                return false;
            }
            if (!Character.isISOControl(ch)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onFinish() {
        if (this.wasSuccessful()) {
            for (TypePair pair : this.allFields) {
                String fieldName = pair.name;
                if (this.map.containsKey(fieldName) || this.isOptionalOrRelationOrSerial(pair)) continue;
                this.addMissingFieldError(String.format("value for field '%s' not added to struct", fieldName), fieldName);
            }
            this.newDVal = new DValueImpl(this.type, this.map);
        }
    }

    private boolean isOptionalOrRelationOrSerial(TypePair pair) {
        if (this.structType.fieldIsOptional(pair.name)) {
            return true;
        }
        if (this.structType.fieldIsSerial(pair.name)) {
            return true;
        }
        return pair.type.isStructShape();
    }
}

