/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import org.delia.type.DType;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.valuebuilder.DValueBuilder;

public class NumberValueBuilder
extends DValueBuilder {
    public NumberValueBuilder(DType type) {
        if (!type.isShape(Shape.NUMBER)) {
            this.addWrongTypeError("expecting number");
            return;
        }
        this.type = type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        Double nval = null;
        try {
            nval = Double.parseDouble(input);
            nval = (double)nval;
            this.newDVal = new DValueImpl(this.type, nval);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not a number", input), input);
        }
    }

    public void buildFrom(Double lval) {
        if (lval == null) {
            this.addNoDataError("no data");
            return;
        }
        this.newDVal = new DValueImpl(this.type, lval);
    }

    @Override
    protected void onFinish() {
    }
}

