/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import org.delia.type.DType;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.valuebuilder.DValueBuilder;

public class LongValueBuilder
extends DValueBuilder {
    public LongValueBuilder(DType type) {
        if (!type.isShape(Shape.LONG)) {
            this.addWrongTypeError("expecting long");
            return;
        }
        this.type = type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        Long nval = null;
        try {
            nval = Long.parseLong(input);
            nval = (long)nval;
            this.newDVal = new DValueImpl(this.type, nval);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not a long integer", input), input);
        }
    }

    public void buildFrom(Long lval) {
        if (lval == null) {
            this.addNoDataError("no data");
            return;
        }
        this.newDVal = new DValueImpl(this.type, lval);
    }

    @Override
    protected void onFinish() {
    }
}

