/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import org.delia.type.DType;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.valuebuilder.DValueBuilder;

public class IntegerValueBuilder
extends DValueBuilder {
    public IntegerValueBuilder(DType type) {
        if (!type.isShape(Shape.INTEGER)) {
            this.addWrongTypeError("expecting int");
            return;
        }
        this.type = type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        Integer nval = null;
        try {
            nval = Integer.parseInt(input);
            nval = (int)nval;
            this.newDVal = new DValueImpl(this.type, nval);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not an integer", input), input);
        }
    }

    public void buildFrom(Integer lval) {
        if (lval == null) {
            this.addNoDataError("no data");
            return;
        }
        this.newDVal = new DValueImpl(this.type, lval);
    }

    @Override
    protected void onFinish() {
    }
}

