/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import java.util.Date;
import org.delia.core.DateFormatService;
import org.delia.core.DateFormatter;
import org.delia.core.FactoryService;
import org.delia.type.DType;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.type.WrappedDate;
import org.delia.valuebuilder.DValueBuilder;

public class DateValueBuilder
extends DValueBuilder {
    private FactoryService factorySvc;
    private DateFormatService fmtSvc;

    public DateValueBuilder(FactoryService factorySvc, DType type) {
        this.factorySvc = factorySvc;
        this.fmtSvc = factorySvc.getDateFormatService();
        if (!type.isShape(Shape.DATE)) {
            this.addWrongTypeError("expecting number");
            return;
        }
        this.type = type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        Date dt = null;
        dt = this.fmtSvc.parse(input);
        if (dt == null) {
            this.addParsingError(String.format("Can't convert '%s' to date", input), input);
            return;
        }
        DateFormatter formatter = this.fmtSvc.createFormatter(input);
        WrappedDate wdt = new WrappedDate(dt, formatter);
        this.newDVal = new DValueImpl(this.type, wdt);
    }

    public void buildFrom(Date dt) {
        if (dt == null) {
            this.addNoDataError("no data");
            return;
        }
        DateFormatter formatter = this.fmtSvc.createFormatter();
        WrappedDate wdt = new WrappedDate(dt, formatter);
        this.newDVal = new DValueImpl(this.type, wdt);
    }

    @Override
    protected void onFinish() {
    }
}

