/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import java.util.ArrayList;
import java.util.List;
import org.delia.error.DetailedError;
import org.delia.error.ErrorType;
import org.delia.type.DType;
import org.delia.type.DValue;

public abstract class DValueBuilder {
    protected List<DetailedError> valErrorList = new ArrayList<DetailedError>();
    protected boolean finished;
    protected DValue newDVal;
    protected DType type;
    public String fieldName;

    public abstract void buildFromString(String var1);

    public boolean finish() {
        this.finished = true;
        this.onFinish();
        boolean ok = this.wasSuccessful();
        return ok;
    }

    protected abstract void onFinish();

    public boolean wasSuccessful() {
        return this.finished && this.valErrorList.isEmpty();
    }

    public List<DetailedError> getValidationErrors() {
        return this.valErrorList;
    }

    public DValue getDValue() {
        return this.newDVal;
    }

    private void addError(DetailedError err) {
        this.valErrorList.add(err);
    }

    public void addParsingError(String msg, String inputText) {
        DetailedError nem = this.addOldErrorMsgZ(ErrorType.PARSINGERROR, msg);
        nem.setActualValue(inputText);
    }

    public void addParsingError(String msg, String inputText, String fieldName) {
        DetailedError nem = this.addOldErrorMsgZ(ErrorType.PARSINGERROR, msg);
        nem.setFieldName(fieldName);
        nem.setActualValue(inputText);
    }

    public DetailedError addOldErrorMsgZ(ErrorType errType, String message) {
        DetailedError err = new DetailedError(errType.name(), message);
        err.setErrorType(DetailedError.Type.IO_ERROR);
        err.setErrorName(errType.name());
        err.setFieldName(this.fieldName == null ? "?" : this.fieldName);
        err.setSrcFile("?");
        err.setTypeName("?");
        this.addError(err);
        return err;
    }

    protected void addNoDataError(String msg) {
        this.addOldErrorMsgZ(ErrorType.NODATA, msg);
    }

    protected void addWrongTypeError(String s) {
        this.addOldErrorMsgZ(ErrorType.WRONGTYPE, String.format("wrong type - %s", s));
    }

    protected void addNoDataError() {
        this.addOldErrorMsgZ(ErrorType.NODATA, "no data");
    }

    protected void addDuplicateFieldError(String msg, String fieldName) {
        this.addOldErrorMsgZ(ErrorType.DUPLICATEFIELD, msg).setFieldName(fieldName);
    }

    protected void addMissingFieldError(String msg, String fieldName) {
        this.addOldErrorMsgZ(ErrorType.MISSINGFIELD, msg).setFieldName(fieldName);
    }

    protected void addUnknownFieldError(String msg) {
        this.addOldErrorMsgZ(ErrorType.UNKNOWNFIELD, msg);
    }

    protected void addRefError(String msg) {
        this.addOldErrorMsgZ(ErrorType.REFERROR, msg);
    }

    public DType getType() {
        return this.type;
    }
}

