/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import org.delia.type.DType;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.valuebuilder.DValueBuilder;

public class BooleanValueBuilder
extends DValueBuilder {
    public BooleanValueBuilder(DType type) {
        if (!type.isShape(Shape.BOOLEAN)) {
            this.addWrongTypeError("expection boolean");
            return;
        }
        this.type = type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        Boolean bool = null;
        try {
            String target = "true";
            String target2 = "false";
            if (target.equalsIgnoreCase(input) || target2.equalsIgnoreCase(input)) {
                bool = Boolean.parseBoolean(input);
                this.newDVal = new DValueImpl(this.type, bool);
            } else {
                this.addParsingError(String.format("'%s' is not an boolean", input), input);
            }
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not an boolean", input), input);
        }
    }

    public void buildFrom(Boolean bool) {
        if (bool == null) {
            this.addNoDataError("no data");
            return;
        }
        this.newDVal = new DValueImpl(this.type, bool);
    }

    @Override
    protected void onFinish() {
    }
}

