/*
 * Decompiled with CFR 0.152.
 */
package org.delia.validation;

import java.util.ArrayList;
import java.util.List;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBCapabilties;
import org.delia.error.SimpleErrorTracker;
import org.delia.rule.AlwaysRuleGuard;
import org.delia.rule.DRule;
import org.delia.rule.DRuleBase;
import org.delia.rule.DRuleContext;
import org.delia.rule.rules.MandatoryRule;
import org.delia.rule.rules.RelationManyRule;
import org.delia.rule.rules.RelationOneRule;
import org.delia.runner.FetchRunner;
import org.delia.runner.ResultValue;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.DValueInternal;
import org.delia.type.TypePair;
import org.delia.type.ValidationState;

public class ValidationRuleRunner
extends ServiceBase {
    private SimpleErrorTracker localET;
    private boolean planModeFlg;
    private boolean enableRelationModifierFlag;
    private DBCapabilties dbCapabilties;
    boolean populateFKsFlag;
    private boolean insertFlag;
    private FetchRunner fetchRunner;

    public ValidationRuleRunner(FactoryService factorySvc, DBCapabilties dbCapabilties, FetchRunner fetchRunner) {
        super(factorySvc);
        this.localET = new SimpleErrorTracker(this.log);
        this.dbCapabilties = dbCapabilties;
        this.fetchRunner = fetchRunner;
    }

    public boolean validateFieldsOnly(DValue dval) {
        this.localET.clear();
        List<DRule> ruleL = this.buildRuleList(dval);
        this.validateStruct(dval, ruleL, true);
        return this.localET.areNoErrors();
    }

    private List<DRule> buildRuleList(DValue dval) {
        ArrayList<DRule> list = new ArrayList<DRule>();
        this.doBuildRuleList(list, dval.getType());
        return list;
    }

    private void doBuildRuleList(List<DRule> list, DType dtype) {
        if (dtype.getBaseType() != null) {
            this.doBuildRuleList(list, dtype.getBaseType());
        }
        for (DRule rule : dtype.getRawRules()) {
            list.add(rule);
        }
    }

    public boolean validateDVal(DValue dval) {
        List<DRule> ruleL = this.buildRuleList(dval);
        return this.doValidateDVal(dval, ruleL);
    }

    private boolean doValidateDVal(DValue dval, List<DRule> ruleL) {
        if (ruleL.isEmpty()) {
            if (ValidationState.UNKNOWN.equals((Object)dval.getValidationState())) {
                if (dval.getType().isStructShape()) {
                    this.validateStruct(dval, ruleL, false);
                    this.setValidIfNeeded(dval);
                    DStructType dtype = (DStructType)dval.getType();
                    for (TypePair pair : dtype.getAllFields()) {
                        DValue inner = dval.asStruct().getField(pair.name);
                        if (inner == null) continue;
                        this.setValidIfNeeded(inner);
                    }
                } else {
                    this.setValidIfNeeded(dval);
                }
            }
            return ValidationState.VALID.equals((Object)dval.getValidationState());
        }
        if (!ValidationState.UNKNOWN.equals((Object)dval.getValidationState())) {
            return true;
        }
        int errCount = this.localET.errorCount();
        if (dval.getType().isStructShape()) {
            this.validateStruct(dval, ruleL, false);
        } else {
            this.validateScalar(dval, ruleL);
        }
        return this.localET.errorCount() == errCount;
    }

    public void validateRelationRules(DValue dval) {
        List<DRule> ruleL = this.buildRuleList(dval);
        for (DRule rule : ruleL) {
            DRuleBase rr;
            if (rule instanceof RelationOneRule) {
                rr = (RelationOneRule)rule;
                ((RelationOneRule)rr).populateFK(dval, this.fetchRunner);
                continue;
            }
            if (!(rule instanceof RelationManyRule)) continue;
            rr = (RelationManyRule)rule;
            ((RelationManyRule)rr).populateFK(dval, this.fetchRunner);
        }
    }

    private void setValidIfNeeded(DValue dval) {
        if (ValidationState.UNKNOWN.equals((Object)dval.getValidationState())) {
            DValueInternal dvi = (DValueInternal)((Object)dval);
            dvi.setValidationState(ValidationState.VALID);
        }
    }

    private void validateStruct(DValue dval, List<DRule> ruleL, boolean validateFieldsOnly) {
        DStructType dtype = (DStructType)dval.getType();
        int failCount = 0;
        for (TypePair pair : dtype.getAllFields()) {
            DValue inner = dval.asStruct().getField(pair.name);
            if (inner == null) {
                MandatoryRule mandatoryRule;
                boolean skip = false;
                if (dtype.fieldIsSerial(pair.name) && this.insertFlag) {
                    skip = true;
                }
                if (validateFieldsOnly || skip || this.execRule(mandatoryRule = new MandatoryRule(new AlwaysRuleGuard(), pair.name), dval)) continue;
                ++failCount;
                continue;
            }
            List<DRule> innerRuleL = this.buildRuleList(inner);
            if (this.doValidateDVal(inner, innerRuleL)) continue;
            ++failCount;
        }
        if (!validateFieldsOnly) {
            for (DRule rule : ruleL) {
                if (this.execRule(rule, dval)) continue;
                ++failCount;
            }
        }
        DValueInternal dvi = (DValueInternal)((Object)dval);
        dvi.setValidationState(failCount == 0 ? ValidationState.VALID : ValidationState.INVALID);
    }

    private void validateScalar(DValue dval, List<DRule> ruleL) {
        int failCount = 0;
        for (DRule rule : ruleL) {
            if (this.execRule(rule, dval)) continue;
            ++failCount;
        }
        DValueInternal dvi = (DValueInternal)((Object)dval);
        dvi.setValidationState(failCount == 0 ? ValidationState.VALID : ValidationState.INVALID);
    }

    private boolean execRule(DRule rule, DValue dval) {
        if (!rule.executeGuard(dval)) {
            this.log.log("skip rule: %s", rule.getName());
            return true;
        }
        SimpleErrorTracker tmpET = new SimpleErrorTracker(this.log);
        DRuleContext ctx = new DRuleContext(tmpET, rule.getName(), this.enableRelationModifierFlag, this.dbCapabilties, this.populateFKsFlag, this.fetchRunner);
        ctx.setPlanModeFlg(this.planModeFlg);
        boolean b = rule.validate(dval, ctx);
        if (!b) {
            this.localET.getErrors().addAll(ctx.getErrors());
        }
        return b;
    }

    public void propogateErrors(ResultValue res) {
        if (!this.localET.areNoErrors()) {
            res.errors.addAll(this.localET.getErrors());
        }
    }

    public boolean validateDVals(List<DValue> dvalList) {
        for (DValue dval : dvalList) {
            if (dval == null) continue;
            this.validateDVal(dval);
        }
        return this.localET.errorCount() > 0;
    }

    public boolean validateDependentRules(DValue partialDVal) {
        List<DRule> ruleL = this.buildRuleList(partialDVal);
        for (String fieldName : partialDVal.asMap().keySet()) {
            for (DRule rule : ruleL) {
                if (!rule.dependsOn(fieldName)) continue;
                this.execRule(rule, partialDVal);
            }
        }
        return this.localET.areNoErrors();
    }

    public boolean validateEndSource() {
        return false;
    }

    public boolean isPlanModeFlg() {
        return this.planModeFlg;
    }

    public void setPlanModeFlg(boolean planModeFlg) {
        this.planModeFlg = planModeFlg;
    }

    public void enableRelationModifier(boolean b) {
        this.enableRelationModifierFlag = b;
    }

    public boolean isPopulateFKsFlag() {
        return this.populateFKsFlag;
    }

    public void setPopulateFKsFlag(boolean populateFKsFlag) {
        this.populateFKsFlag = populateFKsFlag;
    }

    public void enableInsertFlag(boolean b) {
        this.insertFlag = b;
    }
}

