/*
 * Decompiled with CFR 0.152.
 */
package org.delia.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.DValueImpl;
import org.delia.type.TypePair;
import org.delia.util.DeliaExceptionHelper;

public class DValueHelper {
    public static String findUniqueField(DType inner) {
        if (!inner.isStructShape()) {
            return null;
        }
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(inner);
        if (pair == null) {
            return null;
        }
        return pair.name;
    }

    public static TypePair findPrimaryKeyFieldPair(DType inner) {
        if (!inner.isStructShape()) {
            return null;
        }
        DStructType dtype = (DStructType)inner;
        for (TypePair pair : dtype.getAllFields()) {
            if (!dtype.fieldIsPrimaryKey(pair.name)) continue;
            return pair;
        }
        for (TypePair pair : dtype.getAllFields()) {
            if (!dtype.fieldIsUnique(pair.name) || dtype.fieldIsOptional(pair.name)) continue;
            return pair;
        }
        return null;
    }

    public static List<TypePair> findAllUniqueFieldPair(DType inner) {
        if (!inner.isStructShape()) {
            return null;
        }
        ArrayList<TypePair> resultL = new ArrayList<TypePair>();
        DStructType dtype = (DStructType)inner;
        for (TypePair pair : dtype.getAllFields()) {
            if (!dtype.fieldIsPrimaryKey(pair.name)) continue;
            resultL.add(pair);
        }
        for (TypePair pair : dtype.getAllFields()) {
            if (!dtype.fieldIsUnique(pair.name)) continue;
            resultL.add(pair);
        }
        return resultL;
    }

    public static DType findFieldType(DType dtype, String fieldName) {
        if (!dtype.isStructShape()) {
            return null;
        }
        DStructType structType = (DStructType)dtype;
        for (TypePair pair : structType.getAllFields()) {
            if (!pair.name.equals(fieldName)) continue;
            return pair.type;
        }
        return null;
    }

    public static TypePair findField(DType dtype, String fieldName) {
        if (!dtype.isStructShape()) {
            return null;
        }
        DStructType structType = (DStructType)dtype;
        for (TypePair pair : structType.getAllFields()) {
            if (!pair.name.equals(fieldName)) continue;
            return pair;
        }
        return null;
    }

    public static boolean fieldExists(DType dtype, String fieldName) {
        if (!dtype.isStructShape()) {
            return false;
        }
        DStructType structType = (DStructType)dtype;
        for (TypePair pair : structType.getAllFields()) {
            if (!pair.name.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static DType findUniqueFieldType(DType inner) {
        if (!inner.isStructShape()) {
            return null;
        }
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(inner);
        if (pair == null) {
            return null;
        }
        return pair.type;
    }

    public static DValue getFieldValue(DValue dval, String fieldName) {
        if (dval == null || !dval.getType().isStructShape()) {
            return null;
        }
        return dval.asStruct().getField(fieldName);
    }

    public static DValue mergeOne(DValue dvalPartial, DValue existingDVal) {
        DValue clone;
        DValue inner;
        HashMap<String, DValue> srcMap = new HashMap<String, DValue>(dvalPartial.asMap());
        Map<String, DValue> existingMap = existingDVal.asMap();
        Map<String, DValue> newMap = existingDVal.asMap();
        for (String fieldName : existingMap.keySet()) {
            if (srcMap.containsKey(fieldName)) {
                inner = (DValue)srcMap.get(fieldName);
                srcMap.remove(fieldName);
            } else {
                inner = existingMap.get(fieldName);
            }
            clone = DValueHelper.cloneField(inner);
            newMap.put(fieldName, clone);
        }
        for (String fieldName : srcMap.keySet()) {
            inner = (DValue)srcMap.get(fieldName);
            clone = DValueHelper.cloneField(inner);
            newMap.put(fieldName, clone);
        }
        DValueImpl newVal = new DValueImpl(existingDVal.getType(), newMap);
        return newVal;
    }

    public static DValue cloneField(DValue inner) {
        DValueImpl clone;
        if (inner == null) {
            return null;
        }
        if (inner.getObject() instanceof DRelation) {
            DRelation rel = (DRelation)inner.getObject();
            DRelation copy = new DRelation(rel.getTypeName(), rel.getForeignKey());
            clone = new DValueImpl(inner.getType(), copy);
        } else {
            Object obj = inner.getObject();
            clone = new DValueImpl(inner.getType(), obj);
        }
        clone.setValidationState(inner.getValidationState());
        clone.setPersistenceId(inner.getPersistenceId());
        return clone;
    }

    public static String findMatchingRelation(DStructType dtype, DStructType relType) {
        DStructType structType = dtype;
        for (TypePair pair : structType.getAllFields()) {
            if (!pair.type.getName().equals(relType.getName())) continue;
            return pair.name;
        }
        return null;
    }

    public static void throwIfFieldNotExist(String msgPrefix, String fieldName, DValue dval) {
        if (dval == null) {
            return;
        }
        DStructType dtype = (DStructType)dval.getType();
        if (!DValueHelper.fieldExists(dtype, fieldName)) {
            DeliaExceptionHelper.throwError("unknown-field", "%s - can't find field '%s' in type '%s'", msgPrefix, fieldName, dtype.getName());
        }
    }

    public static boolean typeHasSerialPrimaryKey(DType dtype) {
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(dtype);
        if (pair == null) {
            return false;
        }
        DStructType structType = (DStructType)dtype;
        return structType.fieldIsSerial(pair.name);
    }
}

