/*
 * Decompiled with CFR 0.152.
 */
package org.delia.typebuilder;

import org.delia.compiler.ast.StructFieldExp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.ErrorTracker;
import org.delia.type.BuiltInTypes;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.OrderedMap;
import org.delia.type.Shape;
import org.delia.typebuilder.FutureDeclError;
import org.delia.typebuilder.RuleBuilder;

public class TypeBuilder
extends ServiceBase {
    private DTypeRegistry registry;
    private RuleBuilder ruleBuilder;

    public TypeBuilder(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
        this.ruleBuilder = new RuleBuilder(factorySvc, registry);
    }

    public ErrorTracker getErrorTracker() {
        return this.et;
    }

    public DType createType(TypeStatementExp typeStatementExp) {
        this.et.clear();
        if (typeStatementExp.structExp == null) {
            return this.createScalarType(typeStatementExp);
        }
        OrderedMap omap = new OrderedMap();
        for (StructFieldExp fieldExp : typeStatementExp.structExp.argL) {
            DType fieldType = this.getTypeForField(fieldExp);
            omap.add(fieldExp.getFieldName(), fieldType, fieldExp.isOptional, fieldExp.isUnique, fieldExp.isPrimaryKey, fieldExp.isSerial);
        }
        DType baseType = null;
        if (!typeStatementExp.baseTypeName.equals("struct") && (baseType = this.registry.getType(typeStatementExp.baseTypeName)) == null) {
            String msg = String.format("can't find base type '%s' for type '%s'", typeStatementExp.baseTypeName, typeStatementExp.typeName);
            FutureDeclError future = new FutureDeclError("uknown-base-type", msg);
            future.baseTypeName = typeStatementExp.baseTypeName;
            this.et.add(future);
        }
        DStructType dtype = this.findOrCreateType(typeStatementExp.typeName, baseType, omap);
        dtype.getRawRules().clear();
        this.addRules(dtype, typeStatementExp);
        this.ruleBuilder.addRelationRules(dtype, typeStatementExp);
        this.registry.add(typeStatementExp.typeName, dtype);
        if (this.et.errorCount() > 0) {
            return null;
        }
        return dtype;
    }

    private DStructType findOrCreateType(String typeName, DType baseType, OrderedMap omap) {
        DType possibleStruct = this.registry.getType(typeName);
        if (possibleStruct != null && possibleStruct.isStructShape()) {
            DStructType dtype = (DStructType)possibleStruct;
            dtype.internalAdjustType(baseType, omap);
            return dtype;
        }
        return new DStructType(Shape.STRUCT, typeName, baseType, omap);
    }

    private DType createScalarType(TypeStatementExp typeStatementExp) {
        DType baseType = null;
        if (!BuiltInTypes.isBuiltInScalarType(typeStatementExp.baseTypeName)) {
            baseType = this.registry.getType(typeStatementExp.baseTypeName);
            if (baseType == null) {
                String msg = String.format("can't find base type '%s' for scalar type '%s'", typeStatementExp.baseTypeName, typeStatementExp.typeName);
                FutureDeclError future = new FutureDeclError("uknown-scalar-base-type", msg);
                future.baseTypeName = typeStatementExp.baseTypeName;
                this.et.add(future);
                return null;
            }
        } else {
            BuiltInTypes builtInType = BuiltInTypes.fromDeliaTypeName(typeStatementExp.baseTypeName);
            baseType = this.registry.getType(builtInType);
        }
        DType dtype = new DType(baseType.getShape(), typeStatementExp.typeName, baseType);
        this.addRules(dtype, typeStatementExp);
        this.registry.add(typeStatementExp.typeName, dtype);
        return dtype;
    }

    private void addRules(DType dtype, TypeStatementExp typeStatementExp) {
        this.ruleBuilder.addRules(dtype, typeStatementExp);
    }

    private DType getTypeForField(StructFieldExp fieldExp) {
        DType strType = this.registry.getType(BuiltInTypes.STRING_SHAPE);
        DType intType = this.registry.getType(BuiltInTypes.INTEGER_SHAPE);
        DType longType = this.registry.getType(BuiltInTypes.LONG_SHAPE);
        DType numberType = this.registry.getType(BuiltInTypes.NUMBER_SHAPE);
        DType boolType = this.registry.getType(BuiltInTypes.BOOLEAN_SHAPE);
        DType dateType = this.registry.getType(BuiltInTypes.DATE_SHAPE);
        String s = fieldExp.typeName;
        if (s.equals("string")) {
            return strType;
        }
        if (s.equals("int")) {
            return intType;
        }
        if (s.equals("boolean")) {
            return boolType;
        }
        if (s.equals("long")) {
            return longType;
        }
        if (s.equals("number")) {
            return numberType;
        }
        if (s.equals("date")) {
            return dateType;
        }
        DType possibleStruct = this.registry.getType(fieldExp.typeName);
        if (possibleStruct != null) {
            return possibleStruct;
        }
        String msg = String.format("can't find field type '%s'.", fieldExp.typeName);
        FutureDeclError future = new FutureDeclError("uknown-field-type", msg);
        future.baseTypeName = fieldExp.typeName;
        this.et.add(future);
        return null;
    }
}

