/*
 * Decompiled with CFR 0.152.
 */
package org.delia.type;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.delia.type.DType;

public class DTypeHierarchy {
    private Map<DType, BitSet> parentsMap = new ConcurrentHashMap<DType, BitSet>();
    private Map<DType, BitSet> childMap = new ConcurrentHashMap<DType, BitSet>();

    public void build(Map<String, DType> allTypes) {
        for (String typeName : allTypes.keySet()) {
            DType dtype = allTypes.get(typeName);
            BitSet parentBS = new BitSet();
            BitSet childBS = new BitSet();
            this.buildBS(dtype, parentBS, childBS, allTypes);
            this.parentsMap.put(dtype, parentBS);
            this.childMap.put(dtype, childBS);
        }
    }

    private void buildBS(DType target, BitSet parentBS, BitSet childBS, Map<String, DType> allTypes) {
        for (String typeName : allTypes.keySet()) {
            DType dtype = allTypes.get(typeName);
            if (this.calcIsParent(target, dtype)) {
                parentBS.set(dtype.getBitIndex());
            }
            if (!this.calcIsChild(target, dtype)) continue;
            childBS.set(dtype.getBitIndex());
        }
    }

    private boolean calcIsParent(DType type, DType parent) {
        for (DType current = type.getBaseType(); current != null; current = current.getBaseType()) {
            if (current != parent) continue;
            return true;
        }
        return false;
    }

    private boolean calcIsChild(DType target, DType child) {
        return this.calcIsParent(child, target);
    }

    public boolean isParent(DType type, DType parent) {
        BitSet bs = this.parentsMap.get(type);
        if (bs == null) {
            return false;
        }
        return bs.get(parent.getBitIndex());
    }

    public boolean isChild(DType type, DType child) {
        BitSet bs = this.childMap.get(type);
        if (bs == null) {
            return false;
        }
        return bs.get(child.getBitIndex());
    }

    public List<DType> findParentTypes(Map<String, DType> allTypes, DType type) {
        BitSet bs = this.parentsMap.get(type);
        if (bs == null) {
            return null;
        }
        return this.findInBitSet(bs, allTypes);
    }

    public List<DType> findChildTypes(Map<String, DType> allTypes, DType type) {
        BitSet bs = this.childMap.get(type);
        if (bs == null) {
            return null;
        }
        return this.findInBitSet(bs, allTypes);
    }

    private List<DType> findInBitSet(BitSet bs, Map<String, DType> allTypes) {
        ArrayList<DType> resultList = new ArrayList<DType>();
        for (String typeName : allTypes.keySet()) {
            DType dtype = allTypes.get(typeName);
            if (!bs.get(dtype.getBitIndex())) continue;
            resultList.add(dtype);
        }
        return resultList;
    }
}

