/*
 * Decompiled with CFR 0.152.
 */
package org.delia.type;

import java.util.ArrayList;
import java.util.List;
import org.delia.rule.DRule;
import org.delia.type.Shape;
import org.delia.util.NameUtils;

public class DType {
    private Shape shape;
    private String name;
    private String packageName;
    private String completeName;
    private DType baseType;
    private List<DRule> rules = new ArrayList<DRule>();
    private int bitIndex;

    public DType(Shape shape, String name, DType baseType) {
        this.shape = shape;
        this.name = name;
        this.completeName = name;
        this.baseType = baseType;
    }

    public boolean isShape(Shape target) {
        return target != null && target.equals((Object)this.shape);
    }

    public boolean isScalarShape() {
        switch (this.shape) {
            case STRUCT: {
                return false;
            }
        }
        return true;
    }

    public boolean isNumericShape() {
        switch (this.shape) {
            case INTEGER: 
            case LONG: 
            case NUMBER: {
                return true;
            }
        }
        return false;
    }

    public boolean isRelationShape() {
        switch (this.shape) {
            case RELATION: {
                return true;
            }
        }
        return false;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getName() {
        return this.name;
    }

    public DType getBaseType() {
        return this.baseType;
    }

    public boolean isAssignmentCompatible(DType type2) {
        if (this == type2) {
            return true;
        }
        for (DType current = type2.getBaseType(); current != null; current = current.getBaseType()) {
            if (current != this) continue;
            return true;
        }
        return false;
    }

    public List<DRule> getRules() {
        ArrayList<DRule> copy = new ArrayList<DRule>(this.rules);
        return copy;
    }

    public List<DRule> getRawRules() {
        return this.rules;
    }

    public boolean hasRules() {
        return this.rules.size() > 0;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.completeName = NameUtils.completeName(packageName, this.name);
    }

    public String getCompleteName() {
        return this.completeName;
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    public void setBitIndex(int bitIndex) {
        this.bitIndex = bitIndex;
    }

    public boolean isStructShape() {
        return Shape.STRUCT.equals((Object)this.shape);
    }

    public String toString() {
        return this.name;
    }

    public void internalAdjustType(DType baseType) {
        this.baseType = baseType;
    }
}

