/*
 * Decompiled with CFR 0.152.
 */
package org.delia.sort.topo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.delia.sort.topo.DirectedGraph;

public class TopologicalSort {
    public static <T> List<T> sort(DirectedGraph<T> g) {
        DirectedGraph<T> gRev = TopologicalSort.reverseGraph(g);
        ArrayList result = new ArrayList();
        HashSet visited = new HashSet();
        HashSet expanded = new HashSet();
        for (T node : gRev) {
            TopologicalSort.explore(node, gRev, result, visited, expanded);
        }
        return result;
    }

    private static <T> void explore(T node, DirectedGraph<T> g, List<T> ordering, Set<T> visited, Set<T> expanded) {
        if (visited.contains(node)) {
            if (expanded.contains(node)) {
                return;
            }
            throw new IllegalArgumentException("Graph contains a cycle.");
        }
        visited.add(node);
        for (T predecessor : g.edgesFrom(node)) {
            TopologicalSort.explore(predecessor, g, ordering, visited, expanded);
        }
        ordering.add(node);
        expanded.add(node);
    }

    private static <T> DirectedGraph<T> reverseGraph(DirectedGraph<T> g) {
        DirectedGraph<T> result = new DirectedGraph<T>();
        for (T node : g) {
            result.addNode(node);
        }
        for (T node : g) {
            for (T endpoint : g.edgesFrom(node)) {
                result.addEdge(endpoint, node);
            }
        }
        return result;
    }
}

