/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.delia.compiler.ast.ConfigureStatementExp;
import org.delia.compiler.ast.DeleteStatementExp;
import org.delia.compiler.ast.DsonExp;
import org.delia.compiler.ast.EndSourceStatementExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.InsertStatementExp;
import org.delia.compiler.ast.LetStatementExp;
import org.delia.compiler.ast.NullExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.compiler.ast.UpdateStatementExp;
import org.delia.compiler.ast.UserFnCallExp;
import org.delia.compiler.ast.UserFunctionDefStatementExp;
import org.delia.compiler.generate.DeliaGeneratePhase;
import org.delia.core.ConfigureService;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBAccessContext;
import org.delia.db.DBException;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.DBValidationException;
import org.delia.db.InsertContext;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.error.DeliaError;
import org.delia.error.SimpleErrorTracker;
import org.delia.log.Log;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.function.QueryFuncOrFieldRunner;
import org.delia.runner.ConversionResult;
import org.delia.runner.DeliaException;
import org.delia.runner.DsonToDValueConverter;
import org.delia.runner.ExecutionState;
import org.delia.runner.FetchRunnerImpl;
import org.delia.runner.FilterEvaluator;
import org.delia.runner.InternalCompileState;
import org.delia.runner.QueryResponse;
import org.delia.runner.ResultValue;
import org.delia.runner.Runner;
import org.delia.runner.ScalarBuilder;
import org.delia.runner.TypeRunner;
import org.delia.runner.TypeSpec;
import org.delia.runner.VarEvaluator;
import org.delia.runner.VarRef;
import org.delia.sprig.SprigService;
import org.delia.sprig.SprigServiceImpl;
import org.delia.sprig.SprigVarEvaluator;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DTypeRegistryBuilder;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;
import org.delia.validation.ValidationRuleRunner;
import org.delia.valuebuilder.ScalarValueBuilder;

public class RunnerImpl
extends ServiceBase
implements Runner {
    public static final String DOLLAR_DOLLAR = "$$";
    private Map<String, ResultValue> varMap = new HashMap<String, ResultValue>();
    protected DTypeRegistry registry;
    private DBInterface dbInterface;
    private DBExecutor dbexecutor;
    private QueryFuncOrFieldRunner qffRunner;
    protected FetchRunnerImpl fetchRunner;
    private Map<String, UserFunctionDefStatementExp> userFnMap = new HashMap<String, UserFunctionDefStatementExp>();
    private Map<String, String> activeUserFnMap = new HashMap<String, String>();
    private ScalarBuilder scalarBuilder;
    private SprigService sprigSvc;

    public RunnerImpl(FactoryService factorySvc, DBInterface dbInterface) {
        super(factorySvc);
        this.dbInterface = dbInterface;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public DeliaGeneratePhase createGenerator() {
        return new DeliaGeneratePhase(this.factorySvc, this.registry);
    }

    @Override
    public InternalCompileState getCompileState() {
        InternalCompileState ctx = new InternalCompileState();
        for (String typeName : this.registry.getAll()) {
            ctx.compiledTypeMap.put(typeName, this.buildFieldList(typeName));
        }
        ctx.delcaredVarMap.putAll(this.varMap);
        ctx.declaredUserFnMap.putAll(this.userFnMap);
        return ctx;
    }

    @Override
    public ExecutionState getExecutionState() {
        ExecutionState ctx = new ExecutionState();
        ctx.registry = this.registry;
        ctx.varMap.putAll(this.varMap);
        ctx.userFnMap.putAll(this.userFnMap);
        ctx.generator = this.createGenerator();
        ctx.sprigSvc = this.sprigSvc;
        return ctx;
    }

    private TypeSpec buildFieldList(String typeName) {
        DType type = this.registry.getType(typeName);
        TypeSpec spec = new TypeSpec();
        spec.fieldL = new ArrayList<String>();
        String string = spec.baseTypeName = type.getBaseType() == null ? null : type.getBaseType().getName();
        if (!type.isStructShape()) {
            return spec;
        }
        DStructType dtype = (DStructType)this.registry.getType(typeName);
        for (String key : dtype.getDeclaredFields().keySet()) {
            spec.fieldL.add(key);
        }
        return spec;
    }

    @Override
    public boolean init(ExecutionState ctx) {
        if (ctx == null) {
            DTypeRegistryBuilder registryBuilder = new DTypeRegistryBuilder();
            registryBuilder.init();
            this.registry = registryBuilder.getRegistry();
            this.sprigSvc = new SprigServiceImpl(this.factorySvc, this.registry);
        } else {
            this.registry = ctx.registry;
            this.varMap = ctx.varMap;
            this.userFnMap = ctx.userFnMap;
            this.sprigSvc = ctx.sprigSvc;
        }
        this.scalarBuilder = new ScalarBuilder(this.factorySvc, this.registry);
        return true;
    }

    @Override
    public TypeRunner createTypeRunner() {
        TypeRunner typeRunner = new TypeRunner(this.factorySvc, this.registry);
        return typeRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultValue executeProgram(List<Exp> expL) {
        ResultValue res = null;
        DBAccessContext dbctx = new DBAccessContext(this.registry, this);
        this.dbexecutor = this.dbInterface.createExector(dbctx);
        this.fetchRunner = new FetchRunnerImpl(this.factorySvc, this.dbexecutor, this.registry, this);
        this.qffRunner = new QueryFuncOrFieldRunner(this.factorySvc, this.registry, this.fetchRunner, this.dbInterface.getCapabilities());
        try {
            for (Exp exp : expL) {
                res = this.executeStatement(exp);
                if (res.ok) continue;
                ResultValue resultValue = res;
                return resultValue;
            }
        }
        finally {
            if (this.dbexecutor != null) {
                this.dbexecutor.close();
            }
        }
        return res;
    }

    @Override
    public ResultValue executeOneStatement(Exp exp) {
        return this.executeProgram(Collections.singletonList(exp));
    }

    public ResultValue executeStatement(Exp exp) {
        this.log.logDebug("exec: " + exp.toString(), new Object[0]);
        ResultValue res = new ResultValue();
        if (exp instanceof TypeStatementExp) {
            this.executeTypeStatement((TypeStatementExp)exp, res);
        } else if (exp instanceof LetStatementExp) {
            this.executeLetStatement((LetStatementExp)exp, res);
        } else if (exp instanceof InsertStatementExp) {
            this.executeInsertStatement((InsertStatementExp)exp, res);
        } else if (exp instanceof UpdateStatementExp) {
            this.executeUpdateStatement((UpdateStatementExp)exp, res);
        } else if (exp instanceof DeleteStatementExp) {
            this.executeDeleteStatement((DeleteStatementExp)exp, res);
        } else if (exp instanceof UserFunctionDefStatementExp) {
            this.executeUserFuncDefStatement((UserFunctionDefStatementExp)exp, res);
        } else if (exp instanceof EndSourceStatementExp) {
            this.executeEndSource((EndSourceStatementExp)exp, res);
        } else if (exp instanceof ConfigureStatementExp) {
            this.executeConfigureStatement((ConfigureStatementExp)exp, res);
        }
        return res;
    }

    private void executeConfigureStatement(ConfigureStatementExp exp, ResultValue res) {
        ConfigureService configSvc = this.factorySvc.getConfigureService();
        try {
            configSvc.execute(exp, this.registry, this.sprigSvc);
            res.ok = true;
        }
        catch (DeliaException e) {
            res.ok = false;
            res.errors.add(e.getLastError());
        }
    }

    private void executeEndSource(EndSourceStatementExp exp, ResultValue res) {
        ValidationRuleRunner ruleRunner = this.createValidationRunner();
        if (!ruleRunner.validateEndSource()) {
            ruleRunner.propogateErrors(res);
        }
        if (!res.errors.isEmpty()) {
            res.ok = false;
        }
    }

    private ValidationRuleRunner createValidationRunner() {
        return new ValidationRuleRunner(this.factorySvc, this.dbInterface.getCapabilities(), this.fetchRunner);
    }

    private void executeUserFuncDefStatement(UserFunctionDefStatementExp exp, ResultValue res) {
        this.userFnMap.put(exp.funcName, exp);
        res.ok = true;
        res.shape = null;
        res.val = null;
    }

    private void executeTypeStatement(TypeStatementExp exp, ResultValue res) {
        res.ok = true;
    }

    private void executeUpdateStatement(UpdateStatementExp exp, ResultValue res) {
        DType dtype = this.registry.getType(exp.getTypeName());
        if (this.failIfNull(dtype, exp.typeName, res)) {
            return;
        }
        if (this.failIfNotStruct(dtype, exp.typeName, res)) {
            return;
        }
        if (dtype == null) {
            this.addError(res, "type.not.found", String.format("can't find type '%s'", exp.getTypeName()));
            return;
        }
        ConversionResult cres = this.buildPartialValue((DStructType)dtype, exp.dsonExp);
        if (cres.dval == null) {
            res.errors.addAll(cres.localET.getErrors());
            res.ok = false;
            return;
        }
        ValidationRuleRunner ruleRunner = this.createValidationRunner();
        if (!ruleRunner.validateFieldsOnly(cres.dval)) {
            ruleRunner.propogateErrors(res);
        }
        if (!ruleRunner.validateDependentRules(cres.dval)) {
            ruleRunner.propogateErrors(res);
        }
        if (!res.errors.isEmpty()) {
            res.ok = false;
            return;
        }
        try {
            QuerySpec spec = this.resolveFilterVars(exp.queryExp);
            int numRowsAffected = this.dbexecutor.executeUpdate(spec, cres.dval);
            res.ok = true;
            res.shape = Shape.INTEGER;
            res.val = numRowsAffected;
        }
        catch (DBException e) {
            res.errors.add(e.getLastError());
            res.ok = false;
            return;
        }
    }

    private void executeDeleteStatement(DeleteStatementExp exp, ResultValue res) {
        DType dtype = this.registry.getType(exp.getTypeName());
        if (this.failIfNull(dtype, exp.typeName, res)) {
            return;
        }
        if (this.failIfNotStruct(dtype, exp.typeName, res)) {
            return;
        }
        if (dtype == null) {
            this.addError(res, "type.not.found", String.format("can't find type '%s'", exp.getTypeName()));
            return;
        }
        try {
            QuerySpec spec = this.resolveFilterVars(exp.queryExp);
            this.dbexecutor.executeDelete(spec);
        }
        catch (DBException e) {
            res.errors.add(e.getLastError());
            res.ok = false;
            return;
        }
        res.ok = true;
        res.shape = null;
        res.val = null;
    }

    private void addError(ResultValue res, String id, String msg) {
        DeliaError error = this.et.add(id, msg);
        res.errors.add(error);
        res.ok = false;
    }

    private void executeInsertStatement(InsertStatementExp exp, ResultValue res) {
        DType dtype = this.registry.getType(exp.getTypeName());
        if (this.failIfNull(dtype, exp.typeName, res)) {
            return;
        }
        if (this.failIfNotStruct(dtype, exp.typeName, res)) {
            return;
        }
        ConversionResult cres = this.buildValue((DStructType)dtype, exp.dsonExp);
        if (cres.dval == null) {
            res.errors.addAll(cres.localET.getErrors());
            res.ok = false;
            return;
        }
        ValidationRuleRunner ruleRunner = this.createValidationRunner();
        ruleRunner.enableRelationModifier(true);
        ruleRunner.enableInsertFlag(true);
        ConfigureService configSvc = this.factorySvc.getConfigureService();
        ruleRunner.setPopulateFKsFlag(configSvc.isPopulateFKsFlag());
        if (!ruleRunner.validateDVal(cres.dval)) {
            ruleRunner.propogateErrors(res);
        }
        if (!res.errors.isEmpty()) {
            res.ok = false;
            return;
        }
        try {
            String typeName = cres.dval.getType().getName();
            InsertContext ctx = new InsertContext();
            boolean hasSerialId = DValueHelper.typeHasSerialPrimaryKey(cres.dval.getType());
            if (hasSerialId) {
                ctx.extractGeneratedKeys = true;
                ctx.genKeytype = DValueHelper.findPrimaryKeyFieldPair((DType)cres.dval.getType()).type;
                DValue generatedId = this.dbexecutor.executeInsert(cres.dval, ctx);
                boolean sprigFlag = this.sprigSvc.haveEnabledFor(typeName);
                if (sprigFlag) {
                    this.sprigSvc.rememberSynthId(typeName, cres.dval, generatedId, cres.extraMap);
                }
            } else {
                this.dbexecutor.executeInsert(cres.dval, ctx);
            }
        }
        catch (DBException e) {
            res.errors.add(e.getLastError());
            res.ok = false;
            return;
        }
        catch (DBValidationException e) {
            res.errors.add(e.getLastError());
            res.ok = false;
            return;
        }
        res.ok = true;
        res.shape = null;
        res.val = null;
    }

    private boolean failIfNotStruct(DType dtype, String typeName, ResultValue res) {
        if (!dtype.isStructShape()) {
            this.addError(res, "type.not.struct", String.format("cannot insert a scalar type '%s'", typeName));
            return true;
        }
        return false;
    }

    private boolean failIfNull(DType dtype, String typeName, ResultValue res) {
        if (dtype == null) {
            this.addError(res, "type.not.found", String.format("can't find type '%s'", typeName));
            return true;
        }
        return false;
    }

    private ConversionResult buildValue(DStructType dtype, DsonExp dsonExp) {
        ConversionResult cres = new ConversionResult();
        cres.localET = new SimpleErrorTracker(this.log);
        ServiceBase varEvaluator = this;
        varEvaluator = new SprigVarEvaluator(this.factorySvc, this);
        DsonToDValueConverter converter = new DsonToDValueConverter(this.factorySvc, cres.localET, this.registry, (VarEvaluator)((Object)varEvaluator), this.sprigSvc);
        cres.dval = converter.convertOne(dtype.getName(), dsonExp, cres);
        return cres;
    }

    private ConversionResult buildPartialValue(DStructType dtype, DsonExp dsonExp) {
        ConversionResult cres = new ConversionResult();
        cres.localET = new SimpleErrorTracker(this.log);
        DsonToDValueConverter converter = new DsonToDValueConverter(this.factorySvc, cres.localET, this.registry, this, this.sprigSvc);
        cres.dval = converter.convertOnePartial(dtype.getName(), dsonExp);
        return cres;
    }

    private ResultValue executeLetStatement(LetStatementExp exp, ResultValue res) {
        QueryExp queryExp;
        VarRef varRef;
        if (exp.isType("userFunc")) {
            return this.invokeUserFunc(exp, res);
        }
        if (exp.value instanceof QueryExp && (varRef = this.resolveScalarVarReference(queryExp = (QueryExp)exp.value)) != null) {
            res.ok = true;
            res.shape = varRef.dval == null ? varRef.nullShape : varRef.dval.getType().getShape();
            res.val = varRef.dval;
            if (varRef.qresp != null) {
                res.val = varRef.qresp;
            }
            this.assignVar(exp, res);
            return res;
        }
        if (exp.isType("queryResponse")) {
            queryExp = (QueryExp)exp.value;
            varRef = this.resolveVarReference(queryExp);
            if (varRef != null) {
                res.ok = true;
                res.shape = null;
                varRef.qresp.bindFetchFlag = true;
                this.runQueryFnsIfNeeded(queryExp, varRef.qresp, res);
                varRef.qresp.bindFetchFlag = false;
                this.assignVar(exp, res);
                return res;
            }
            if (queryExp.filter != null && queryExp.filter.cond instanceof NullExp) {
                DeliaError err = this.et.add("null-filter-not-allowed", "[null] is not allowed");
                throw new DeliaException(err);
            }
            QuerySpec spec = this.resolveFilterVars(queryExp);
            QueryContext qtx = this.buildQueryContext(spec);
            QueryResponse qresp = this.dbexecutor.executeQuery(spec, qtx);
            res.ok = qresp.ok;
            res.addIfNotNull(qresp.err);
            res.shape = null;
            res.val = qresp;
            if (qresp.ok) {
                this.runQueryFnsIfNeeded(queryExp, qresp, res);
            }
            this.assignVar(exp, res);
            return res;
        }
        res.val = this.toObject(exp.value, exp, res);
        if (exp.typeName != null) {
            res.shape = this.toShape(exp.typeName, res.val);
        }
        res.ok = res.errors.isEmpty();
        this.assignVar(exp, res);
        return res;
    }

    private QueryContext buildQueryContext(QuerySpec spec) {
        QueryFuncContext ctx = new QueryFuncContext();
        this.qffRunner.buildPendingTrail(ctx, spec.queryExp);
        QueryContext qtx = new QueryContext();
        qtx.loadFKs = ctx.pendingTrail.getTrail().contains("fks");
        if (!qtx.loadFKs) {
            ConfigureService configSvc = this.factorySvc.getConfigureService();
            qtx.loadFKs = configSvc.isPopulateFKsFlag();
        }
        return qtx;
    }

    private QuerySpec resolveFilterVars(QueryExp queryExp) {
        QuerySpec spec = new QuerySpec();
        spec.queryExp = queryExp;
        spec.evaluator = new FilterEvaluator(this.factorySvc, this);
        spec.evaluator.init(queryExp);
        return spec;
    }

    private ResultValue invokeUserFunc(LetStatementExp exp, ResultValue resParam) {
        RunnerImpl innerRunner = new RunnerImpl(this.factorySvc, this.dbInterface);
        ExecutionState execState = this.getExecutionState();
        execState.varMap.clear();
        boolean b = innerRunner.init(execState);
        if (!b) {
            return resParam;
        }
        UserFnCallExp callExp = (UserFnCallExp)exp.value;
        UserFunctionDefStatementExp userFnExp = this.userFnMap.get(callExp.funcName);
        if (userFnExp == null) {
            return resParam;
        }
        if (this.activeUserFnMap.containsKey(userFnExp.funcName)) {
            DeliaError err = this.et.add("user-func-self-invoke", "A user function may not invoke itself - function %s", userFnExp.funcName);
            throw new DeliaException(err);
        }
        int i = 0;
        for (Exp exp2 : userFnExp.argsL) {
            String argName = exp2.strValue();
            Exp tmpExp = callExp.argL.get(i);
            ResultValue tmpRes = new ResultValue();
            tmpRes.ok = true;
            tmpRes.shape = Shape.INTEGER;
            QueryResponse qr = new QueryResponse();
            qr.dvalList = new ArrayList<DValue>();
            qr.dvalList.add(this.createDValFrom(tmpExp));
            tmpRes.val = qr;
            innerRunner.varMap.put(argName, tmpRes);
            ++i;
        }
        ResultValue finalRes = null;
        ResultValue resultValue = innerRunner.executeProgram(userFnExp.bodyExp.statementL);
        if (!resultValue.ok) {
            resParam.ok = false;
            resParam.errors.addAll(resultValue.errors);
            return resParam;
        }
        finalRes = resultValue;
        if (finalRes != null) {
            this.assignVar(exp, finalRes);
        }
        resParam.errors = finalRes.errors;
        resParam.ok = finalRes.ok;
        resParam.shape = finalRes.shape;
        resParam.val = finalRes.val;
        return resParam;
    }

    private DValue createDValFrom(Exp tmpExp) {
        ScalarValueBuilder builder = this.factorySvc.createScalarValueBuilder(this.registry);
        DValue dval = builder.buildInt(tmpExp.strValue());
        return dval;
    }

    public void runQueryFnsIfNeeded(QueryExp queryExp, QueryResponse qresp, ResultValue res) {
        ValidationRuleRunner ruleRunner;
        QueryResponse qresp2 = this.qffRunner.process(queryExp, qresp);
        res.ok = qresp2.ok;
        res.addIfNotNull(qresp2.err);
        res.shape = null;
        res.val = qresp2;
        if (qresp2.ok && CollectionUtils.isNotEmpty(qresp2.dvalList) && !(ruleRunner = this.createValidationRunner()).validateDVals(qresp.dvalList)) {
            ruleRunner.propogateErrors(res);
        }
    }

    private void assignVar(LetStatementExp exp, ResultValue res) {
        String varName = exp.varName;
        if (!varName.equals(DOLLAR_DOLLAR) && this.exists(varName)) {
            this.addError(res, "var-already-exists", String.format("variable '%s' already exists. Cannot re-assign", varName));
            return;
        }
        res.varName = varName;
        this.varMap.put(varName, res);
        this.varMap.put(DOLLAR_DOLLAR, res);
    }

    private VarRef resolveScalarVarReference(QueryExp queryExp) {
        ResultValue res = this.varMap.get(queryExp.typeName);
        if (res == null) {
            return null;
        }
        VarRef varRef = new VarRef();
        varRef.varRef = queryExp.typeName;
        if (res.val instanceof DValue) {
            varRef.dval = (DValue)res.val;
            return varRef;
        }
        if (res.val instanceof QueryResponse) {
            QueryResponse qresp = (QueryResponse)res.val;
            qresp.bindFetchFlag = true;
            QueryResponse qresp2 = this.qffRunner.process(queryExp, qresp);
            qresp.bindFetchFlag = false;
            if (qresp2.ok) {
                if (qresp2.dvalList == null) {
                    varRef.dval = null;
                    return varRef;
                }
                varRef.qresp = qresp2;
                return varRef;
            }
        } else if (res.val == null) {
            varRef.dval = null;
            varRef.nullShape = res.shape;
            return varRef;
        }
        return null;
    }

    private VarRef resolveVarReference(QueryExp queryExp) {
        QueryResponse qresp;
        ResultValue res = this.varMap.get(queryExp.typeName);
        if (res == null) {
            return null;
        }
        VarRef varRef = new VarRef();
        varRef.varRef = queryExp.typeName;
        varRef.qresp = qresp = (QueryResponse)res.val;
        return varRef;
    }

    private DValue toObject(Exp valueExp, LetStatementExp exp, ResultValue res) {
        ValidationRuleRunner ruleRunner;
        int numErr = this.et.errorCount();
        DValue dval = this.scalarBuilder.buildDValue(valueExp, exp.isTypeExplicit ? exp.typeName : null);
        if (this.et.errorCount() != numErr) {
            SimpleErrorTracker set = (SimpleErrorTracker)this.et;
            List<DeliaError> list = set.getErrorsSinceMark(numErr);
            res.errors.addAll(list);
        }
        if (dval != null && !(ruleRunner = this.createValidationRunner()).validateDVal(dval)) {
            ruleRunner.propogateErrors(res);
        }
        return dval;
    }

    private Shape toShape(String typeName, Object val) {
        Shape shape = Shape.createFromDeliaType(typeName);
        if (shape != null) {
            return shape;
        }
        if (val instanceof DValue) {
            DValue dval = (DValue)val;
            return dval.getType().getShape();
        }
        DType dtype = this.registry.getType(typeName);
        return dtype == null ? null : dtype.getShape();
    }

    @Override
    public boolean exists(String varName) {
        return this.varMap.containsKey(varName);
    }

    @Override
    public ResultValue getVar(String varName) {
        return this.varMap.get(varName);
    }

    @Override
    public DTypeRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public List<DValue> lookupVar(String varName) {
        ResultValue res = this.varMap.get(varName);
        if (res == null) {
            return null;
        }
        if (res.val instanceof DValue) {
            DValue dval = (DValue)res.val;
            return Collections.singletonList(dval);
        }
        QueryResponse qresp = (QueryResponse)res.val;
        return qresp.dvalList;
    }

    @Override
    public String evalVarAsString(String varName, String typeName) {
        ResultValue res = this.varMap.get(varName);
        if (res == null) {
            DeliaExceptionHelper.throwError("unknown-variable", "Can't find variable '%s", varName);
        }
        if (res.val == null) {
            return null;
        }
        if (res.val instanceof DValue) {
            return res.getAsDValue().asString();
        }
        QueryResponse qresp = (QueryResponse)res.val;
        return qresp.getOne().asString();
    }

    @Override
    public SprigService getSprigSvc() {
        return this.sprigSvc;
    }
}

