/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.List;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.DeliaError;
import org.delia.relation.RelationCardinality;
import org.delia.relation.RelationInfo;
import org.delia.rule.DRule;
import org.delia.rule.DRuleBase;
import org.delia.rule.rules.RelationManyRule;
import org.delia.rule.rules.RelationOneRule;
import org.delia.sort.topo.DeliaTypeSorter;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DRuleHelper;
import org.delia.util.StringUtil;

public class RulePostProcessor
extends ServiceBase {
    public RulePostProcessor(FactoryService factorySvc) {
        super(factorySvc);
    }

    public void process(DTypeRegistry registry, List<DeliaError> allErrors) {
        this.buildRelInfos(registry);
        this.setParentFlagsIfNeeded(registry);
        DeliaTypeSorter typeSorter = new DeliaTypeSorter();
        try {
            List<String> orderL = typeSorter.topoSort(registry);
            this.log.log("types: %s", StringUtil.flatten(orderL));
        }
        catch (IllegalArgumentException e) {
            DeliaError err = new DeliaError("type-dependency-cycle", "did you forget a 'parent' modifier?");
            allErrors.add(err);
            return;
        }
    }

    private void buildRelInfos(DTypeRegistry registry) {
        for (String typeName : registry.getAll()) {
            DType dtype = registry.getType(typeName);
            if (!dtype.isStructShape()) continue;
            DStructType structType = (DStructType)dtype;
            for (TypePair pair : structType.getAllFields()) {
                if (!pair.type.isStructShape()) continue;
                for (DRule rule : structType.getRawRules()) {
                    boolean b;
                    TypePair farSide;
                    RelationInfo info;
                    DRuleBase rr;
                    if (rule instanceof RelationOneRule) {
                        rr = (RelationOneRule)rule;
                        ((RelationOneRule)rr).relInfo = info = new RelationInfo();
                        farSide = DRuleHelper.findMatchingRelByType((DStructType)pair.type, structType);
                        b = farSide == null ? false : this.isOtherSideMany(pair.type, farSide);
                        info.cardinality = b ? RelationCardinality.ONE_TO_MANY : RelationCardinality.ONE_TO_ONE;
                        info.farType = (DStructType)pair.type;
                        info.fieldName = rule.getSubject();
                        info.isOneWay = farSide == null;
                        info.isParent = ((RelationOneRule)rr).isParent();
                        info.nearType = structType;
                        continue;
                    }
                    if (!(rule instanceof RelationManyRule)) continue;
                    rr = (RelationManyRule)rule;
                    ((RelationManyRule)rr).relInfo = info = new RelationInfo();
                    farSide = ((RelationManyRule)rr).findMatchingRel((DStructType)pair.type, structType);
                    b = this.isOtherSideMany(pair.type, farSide);
                    info.cardinality = b ? RelationCardinality.MANY_TO_MANY : RelationCardinality.ONE_TO_MANY;
                    info.farType = (DStructType)pair.type;
                    info.fieldName = rule.getSubject();
                    info.isOneWay = false;
                    info.isParent = false;
                    info.nearType = structType;
                }
            }
        }
    }

    private void setParentFlagsIfNeeded(DTypeRegistry registry) {
        for (String typeName : registry.getAll()) {
            DType dtype = registry.getType(typeName);
            if (!dtype.isStructShape()) continue;
            DStructType structType = (DStructType)dtype;
            for (DRule rule : structType.getRawRules()) {
                boolean b;
                RelationInfo info;
                DRuleBase rr;
                if (rule instanceof RelationOneRule) {
                    RelationInfo farSideInfo;
                    rr = (RelationOneRule)rule;
                    info = ((RelationOneRule)rr).relInfo;
                    boolean isOptional = info.nearType.fieldIsOptional(info.fieldName);
                    if (!isOptional || (farSideInfo = DRuleHelper.findOtherSideOne(info.farType, info.nearType)) == null || farSideInfo.nearType.fieldIsOptional(farSideInfo.fieldName)) continue;
                    ((RelationOneRule)rr).forceParentFlag(true);
                    info.isParent = true;
                    continue;
                }
                if (!(rule instanceof RelationManyRule)) continue;
                rr = (RelationManyRule)rule;
                info = ((RelationManyRule)rr).relInfo;
                info.isParent = b = this.isOtherSideOne(info.farType, structType);
            }
        }
    }

    private boolean isOtherSideOne(DType otherSide, DStructType structType) {
        return DRuleHelper.isOtherSideOne(otherSide, structType);
    }

    private boolean isOtherSideMany(DType otherSide, TypePair otherRelPair) {
        return DRuleHelper.isOtherSideMany(otherSide, otherRelPair);
    }
}

