/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.ArrayList;
import java.util.List;
import org.delia.error.DeliaError;
import org.delia.runner.QueryResponse;
import org.delia.type.DValue;
import org.delia.type.Shape;

public class ResultValue {
    public boolean ok;
    public List<DeliaError> errors = new ArrayList<DeliaError>();
    public Shape shape;
    public Object val;
    public String varName;

    public void copyFrom(ResultValue other) {
        this.errors.clear();
        this.errors.addAll(other.errors);
        this.ok = other.ok;
        this.shape = other.shape;
        this.val = other.val;
    }

    public void addIfNotNull(DeliaError err) {
        if (err != null) {
            this.errors.add(err);
        }
    }

    public DValue getAsDValue() {
        if (this.val instanceof QueryResponse) {
            QueryResponse qresp = (QueryResponse)this.val;
            if (qresp.dvalList == null) {
                return null;
            }
            if (qresp.dvalList.size() != 1) {
                return null;
            }
            return qresp.dvalList.get(0);
        }
        DValue dval = (DValue)this.val;
        return dval;
    }

    public int getDValueCount() {
        if (this.val instanceof QueryResponse) {
            QueryResponse qresp = (QueryResponse)this.val;
            if (qresp.dvalList == null) {
                return 0;
            }
            return qresp.dvalList.size();
        }
        return 0;
    }

    public List<DValue> getAsDValueList() {
        if (this.val instanceof QueryResponse) {
            QueryResponse qresp = (QueryResponse)this.val;
            return qresp.dvalList;
        }
        return null;
    }

    public DeliaError getLastError() {
        return this.errors.isEmpty() ? null : this.errors.get(this.errors.size() - 1);
    }
}

