/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import org.delia.compiler.ast.QueryExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBExecutor;
import org.delia.db.QueryBuilderService;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.runner.FetchRunner;
import org.delia.runner.FilterEvaluator;
import org.delia.runner.QueryResponse;
import org.delia.runner.VarEvaluator;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;

public class FetchRunnerImpl
extends ServiceBase
implements FetchRunner {
    private DTypeRegistry registry;
    private VarEvaluator varEvaluator;
    private DBExecutor dbexecutor;

    public FetchRunnerImpl(FactoryService factorySvc, DBExecutor dbexecutor, DTypeRegistry registry, VarEvaluator eval) {
        super(factorySvc);
        this.dbexecutor = dbexecutor;
        this.registry = registry;
        this.varEvaluator = eval;
    }

    @Override
    public QueryResponse load(DRelation drel, String targetFieldName) {
        QueryExp queryExp = this.buildQuery(drel);
        QuerySpec spec = new QuerySpec();
        spec.queryExp = queryExp;
        spec.evaluator = new FilterEvaluator(this.factorySvc, this.varEvaluator);
        spec.evaluator.init(spec.queryExp);
        QueryContext qtx = new QueryContext();
        QueryResponse qresp = this.dbexecutor.executeQuery(spec, qtx);
        return qresp;
    }

    private QueryExp buildQuery(DRelation drel) {
        if (drel.isMultipleKey()) {
            DType relType = this.registry.getType(drel.getTypeName());
            QueryBuilderService builderSvc = this.factorySvc.getQueryBuilderService();
            QueryExp exp = builderSvc.createInQuery(drel.getTypeName(), drel.getMultipleKeys(), relType);
            return exp;
        }
        QueryBuilderService builderSvc = this.factorySvc.getQueryBuilderService();
        QueryExp exp = builderSvc.createPrimaryKeyQuery(drel.getTypeName(), drel.getForeignKey());
        return exp;
    }

    private QueryExp buildOwningTypeQuery(DStructType owningType, String fieldName, DRelation drel) {
        QueryBuilderService builderSvc = this.factorySvc.getQueryBuilderService();
        QueryExp exp = builderSvc.createEqQuery(owningType.getName(), fieldName, drel.getForeignKey());
        return exp;
    }

    @Override
    public QueryResponse queryOwningType(DStructType owningType, String fieldName, DRelation drel) {
        QueryExp queryExp = this.buildOwningTypeQuery(owningType, fieldName, drel);
        QuerySpec spec = new QuerySpec();
        spec.queryExp = queryExp;
        spec.evaluator = new FilterEvaluator(this.factorySvc, this.varEvaluator);
        spec.evaluator.init(spec.queryExp);
        QueryContext qtx = new QueryContext();
        QueryResponse qresp = this.dbexecutor.executeQuery(spec, qtx);
        return qresp;
    }

    @Override
    public QueryResponse load(String typeName, String fieldName, DValue keyVal) {
        QueryBuilderService builderSvc = this.factorySvc.getQueryBuilderService();
        QueryExp queryExp = builderSvc.createEqQuery(typeName, fieldName, keyVal);
        QuerySpec spec = new QuerySpec();
        spec.queryExp = queryExp;
        spec.evaluator = new FilterEvaluator(this.factorySvc, this.varEvaluator);
        spec.evaluator.init(spec.queryExp);
        QueryContext qtx = new QueryContext();
        QueryResponse qresp = this.dbexecutor.executeQuery(spec, qtx);
        return qresp;
    }
}

