/*
 * Decompiled with CFR 0.152.
 */
package org.delia.rule.rules;

import java.util.Date;
import org.delia.core.DateFormatService;
import org.delia.rule.DRuleBase;
import org.delia.rule.DRuleContext;
import org.delia.rule.DValueRuleOperand;
import org.delia.rule.RuleGuard;
import org.delia.rule.RuleOperand;
import org.delia.rule.RuleRuleOperand;
import org.delia.type.DRelation;
import org.delia.type.DValue;
import org.delia.type.Shape;

public class CompareOpRule
extends DRuleBase {
    private RuleOperand oper1;
    private String op;
    private RuleOperand oper2;
    private DateFormatService fmtSvc;

    public CompareOpRule(RuleGuard guard, RuleOperand oper1, String op, RuleOperand oper2, DateFormatService fmtSvc) {
        super("compare", guard);
        this.oper1 = oper1;
        this.op = op;
        this.oper2 = oper2;
        this.fmtSvc = fmtSvc;
    }

    @Override
    protected boolean onValidate(DValue dval, DRuleContext ctx) {
        Integer n;
        Comparable<Date> obj1 = this.getAsObject(this.oper1, dval, ctx);
        Comparable<Date> obj2 = this.getAsObject(this.oper2, dval, ctx);
        if (ctx.hasErrors()) {
            return false;
        }
        if (obj1 instanceof Date && obj2 instanceof String) {
            obj2 = this.fmtSvc.parse((String)((Object)obj2));
        } else if (obj1 instanceof String && obj2 instanceof Date) {
            obj1 = this.fmtSvc.parse((String)((Object)obj1));
        }
        if (obj1 instanceof Long && obj2 instanceof Integer) {
            n = (Integer)obj2;
            obj2 = new Long(n.longValue());
        } else if (obj1 instanceof Integer && obj2 instanceof Long) {
            n = (Integer)obj1;
            obj1 = new Long(n.longValue());
        }
        if (obj1 instanceof Double && obj2 instanceof Integer) {
            n = (Integer)obj2;
            obj2 = new Double(n.doubleValue());
        } else if (obj1 instanceof Integer && obj2 instanceof Double) {
            n = (Integer)obj1;
            obj1 = new Double(n.doubleValue());
        }
        boolean b = false;
        switch (this.op) {
            case "<": {
                b = obj1.compareTo((Date)obj2) < 0;
                break;
            }
            case "<=": {
                b = obj1.compareTo((Date)obj2) <= 0;
                break;
            }
            case ">": {
                b = obj1.compareTo((Date)obj2) > 0;
                break;
            }
            case ">=": {
                b = obj1.compareTo((Date)obj2) >= 0;
                break;
            }
            case "==": {
                b = obj1.compareTo((Date)obj2) == 0;
                break;
            }
            case "!=": {
                b = obj1.compareTo((Date)obj2) != 0;
                break;
            }
        }
        if (!b) {
            String s1 = String.format("%s", obj1);
            String s2 = String.format("%s", obj2);
            String msg = String.format("rulefail '%s' in '%s'", s1, s2);
            ctx.addError(this, msg);
        }
        return b;
    }

    private Comparable<?> getAsObject(RuleOperand oper, DValue dval, DRuleContext ctx) {
        if (oper == null) {
            oper = new DValueRuleOperand();
        }
        if (oper instanceof RuleRuleOperand) {
            RuleRuleOperand rro = (RuleRuleOperand)oper;
            Comparable obj = (Comparable)rro.exec(dval, ctx);
            return obj;
        }
        Shape shape = oper.getShape(dval);
        if (shape == null) {
            return null;
        }
        switch (shape) {
            case INTEGER: {
                return oper.asInt(dval);
            }
            case LONG: {
                return oper.asLong(dval);
            }
            case NUMBER: {
                return oper.asNumber(dval);
            }
            case DATE: {
                return oper.asDate(dval);
            }
            case RELATION: {
                return this.getRelationKeyAsObject(oper, dval, ctx);
            }
        }
        return oper.asString(dval);
    }

    private Comparable<?> getRelationKeyAsObject(RuleOperand oper, DValue dval, DRuleContext ctx) {
        DRelation drel = oper.asRelation(dval);
        DValue keyVal = drel.getForeignKey();
        Shape shape = keyVal.getType().getShape();
        if (shape == null) {
            return null;
        }
        switch (shape) {
            case INTEGER: {
                return keyVal.asInt();
            }
            case LONG: {
                return keyVal.asLong();
            }
            case NUMBER: {
                return keyVal.asNumber();
            }
            case DATE: {
                return keyVal.asDate();
            }
        }
        return keyVal.asString();
    }

    @Override
    public boolean dependsOn(String fieldName) {
        return this.oper1.dependsOn(fieldName) || this.oper2.dependsOn(fieldName);
    }

    @Override
    public String getSubject() {
        String s1 = this.oper1.getSubject();
        String s2 = this.oper2.getSubject();
        return String.format("%s %s %s", s1, this.op, s2);
    }
}

