/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import org.delia.api.Delia;
import org.delia.api.DeliaSession;
import org.delia.db.DBInterface;
import org.delia.db.DBInterfaceInternal;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class StatusCmd
extends CmdBase {
    public StatusCmd() {
        super("status", null);
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            StatusCmd cmd = new StatusCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        if (!runner.inSession()) {
            this.log("a session has not been created.");
            return this.createEmptyRes();
        }
        DeliaSession sess = runner.getMostRecentSess();
        Delia delia = runner.getDelia();
        DBInterface dbInterface = delia.getDBInterface();
        int numTypes = sess.getExecutionContext().registry.size();
        DBInterfaceInternal dbi = (DBInterfaceInternal)((Object)dbInterface);
        String summ = dbi.getConnectionSummary();
        this.log(String.format("session: %s", runner.getSessionName()));
        this.log(String.format("             database: %s - %s", dbInterface.getDBType().name(), summ));
        this.log(String.format("      number of types: %d", numTypes -= 7));
        this.log(String.format("  number of variables: %d", sess.getExecutionContext().varMap.size() - 1));
        return this.createEmptyRes();
    }
}

