/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import java.util.ArrayList;
import java.util.List;
import org.delia.api.DeliaSession;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;
import org.delia.type.BuiltInTypes;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;

public class ListTypesCmd
extends CmdBase {
    public ListTypesCmd() {
        super("list types", "lt");
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            ListTypesCmd cmd = new ListTypesCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        DeliaSession sess = runner.getMostRecentSess();
        if (sess == null) {
            this.log("no types have been defined.");
            return this.createEmptyRes();
        }
        DTypeRegistry registry = sess.getExecutionContext().registry;
        List<DType> list = this.getAllTypes(registry);
        String s = String.format("Number of types: %d", list.size());
        this.log(s);
        for (DType dtype : list) {
            DType baseType = dtype.getBaseType();
            String base = baseType == null ? "" : baseType.getName();
            s = String.format("  %s %s", dtype.getName(), base);
            this.log(s);
        }
        ResultValue res = new ResultValue();
        res.ok = true;
        return res;
    }

    private List<DType> getAllTypes(DTypeRegistry registry) {
        ArrayList<DType> list = new ArrayList<DType>();
        for (DType dtype : registry.getOrderedList()) {
            String typeName = BuiltInTypes.convertDTypeNameToDeliaName(dtype.getName());
            if (BuiltInTypes.isBuiltInScalarType(typeName) || typeName.equals("relation")) continue;
            list.add(dtype);
        }
        return list;
    }
}

