/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import org.delia.api.Delia;
import org.delia.db.DBType;
import org.delia.db.h2.test.H2TestCleaner;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class CleanTablesCmd
extends CmdBase {
    public CleanTablesCmd() {
        super("clean tables", null);
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            CleanTablesCmd cmd = new CleanTablesCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        Delia delia = runner.getDelia();
        if (!delia.getDBInterface().getDBType().equals((Object)DBType.H2)) {
            this.log("error: this command is only avalailable for H2.");
            return this.createEmptyRes();
        }
        H2TestCleaner cleaner = new H2TestCleaner();
        cleaner.deleteKnownTables(delia.getFactoryService(), delia.getDBInterface());
        return this.createEmptyRes();
    }
}

