/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.QueryFieldExp;
import org.delia.compiler.ast.QueryFuncExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBCapabilties;
import org.delia.queryresponse.FuncScope;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunction;
import org.delia.queryresponse.QueryResponseFunctionFactory;
import org.delia.runner.FetchRunner;
import org.delia.runner.QueryResponse;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DValueHelper;
import org.delia.util.StringTrail;

public class QueryFuncOrFieldRunner
extends ServiceBase {
    private QueryResponseFunctionFactory funcFactory;
    private DTypeRegistry registry;
    private DBCapabilties dbCapabilities;

    public QueryFuncOrFieldRunner(FactoryService factorySvc, DTypeRegistry registry, FetchRunner fetchRunner, DBCapabilties dbCapabilties) {
        super(factorySvc);
        this.registry = registry;
        this.funcFactory = new QueryResponseFunctionFactory(factorySvc, fetchRunner);
        this.dbCapabilities = dbCapabilties;
    }

    public QueryResponse process(QueryExp queryExp, QueryResponse qresp0) {
        QueryResponse result = qresp0;
        if (CollectionUtils.isNotEmpty(queryExp.qfelist)) {
            QueryFuncContext ctx = new QueryFuncContext();
            ctx.scope = new FuncScope(result);
            ctx.dbCapabilities = this.dbCapabilities;
            this.buildPendingTrail(ctx, queryExp);
            Iterator<QueryFuncExp> iterator = queryExp.qfelist.iterator();
            while (iterator.hasNext()) {
                QueryFuncExp qfexp;
                ctx.qfexp = qfexp = iterator.next();
                if (qfexp instanceof QueryFieldExp) {
                    if (this.endsWithFn(queryExp) && ctx.dbCapabilities.supportsOffsetAndLimit()) continue;
                    QueryFieldExp qff = (QueryFieldExp)qfexp;
                    String fieldName = qff.funcName;
                    this.log.log("qff: " + fieldName, new Object[0]);
                    ArrayList<DValue> newList = new ArrayList<DValue>();
                    boolean checkFieldExists = true;
                    for (DValue dval : ctx.getDValList()) {
                        if (checkFieldExists) {
                            checkFieldExists = false;
                            DValueHelper.throwIfFieldNotExist("", fieldName, dval);
                        }
                        DValue inner = dval.asStruct().getField(qff.funcName);
                        newList.add(inner);
                    }
                    result.dvalList = newList;
                } else {
                    String fnName = qfexp.funcName;
                    this.log.log("qfn: " + fnName, new Object[0]);
                    QueryResponseFunction func = this.funcFactory.create(fnName, this.registry);
                    if (func == null) {
                        result.err = this.et.getLastError();
                        result.ok = false;
                    } else {
                        result = func.process(fnName, queryExp, result, ctx);
                    }
                }
                ++ctx.currentFnIndex;
            }
        }
        return result;
    }

    private boolean endsWithFn(QueryExp queryExp) {
        boolean lastWasFn = false;
        for (QueryFuncExp qfexp : queryExp.qfelist) {
            if (qfexp instanceof QueryFieldExp) {
                lastWasFn = false;
                continue;
            }
            lastWasFn = true;
        }
        return lastWasFn;
    }

    public void buildPendingTrail(QueryFuncContext ctx, QueryExp queryExp) {
        StringTrail trail = new StringTrail();
        for (QueryFuncExp qfexp : queryExp.qfelist) {
            if (qfexp instanceof QueryFieldExp) {
                QueryFieldExp qff = (QueryFieldExp)qfexp;
                String fieldName = qff.funcName;
                this.log.log("qff: " + fieldName, new Object[0]);
                break;
            }
            String fnName = qfexp.funcName;
            this.log.log("qfn: " + fnName, new Object[0]);
            trail.add(fnName);
        }
        ctx.pendingTrail = trail;
    }
}

