/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.QueryFuncExp;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunctionBase;
import org.delia.runner.QueryResponse;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DValueHelper;

public class OrderByFunction
extends QueryResponseFunctionBase {
    public OrderByFunction(DTypeRegistry registry) {
        super(registry);
    }

    @Override
    public QueryResponse process(String fnName, QueryExp queryExp, QueryResponse qresp, QueryFuncContext ctx) {
        if (ctx.dbCapabilities.supportsOrderBy()) {
            return qresp;
        }
        List<DValue> dvalList = ctx.getDValList();
        if (dvalList == null || dvalList.size() <= 1) {
            return qresp;
        }
        String fieldName = this.getStringArg(queryExp, ctx);
        TreeMap<Object, DValue> map = new TreeMap<Object, DValue>();
        ArrayList<DValue> nulllist = new ArrayList<DValue>();
        boolean checkFieldExists = true;
        for (DValue dValue : dvalList) {
            DValue inner;
            if (checkFieldExists) {
                checkFieldExists = false;
                DValueHelper.throwIfFieldNotExist("orderBy", fieldName, dValue);
            }
            if ((inner = dValue.asStruct().getField(fieldName)) == null) {
                nulllist.add(dValue);
                continue;
            }
            map.put(inner.getObject(), dValue);
        }
        ArrayList<DValue> newlist = new ArrayList<DValue>();
        for (Object key : map.keySet()) {
            newlist.add((DValue)map.get(key));
        }
        boolean bl = this.isAsc(queryExp, ctx);
        if (bl) {
            nulllist.addAll(newlist);
            newlist = nulllist;
        } else {
            newlist.addAll(nulllist);
        }
        if (!bl) {
            Collections.reverse(newlist);
        }
        qresp.dvalList = newlist;
        return qresp;
    }

    private boolean isAsc(QueryExp queryExp, QueryFuncContext ctx) {
        QueryFuncExp exp = queryExp.qfelist.get(ctx.currentFnIndex);
        if (exp.argL.size() == 2) {
            Exp arg = exp.argL.get(1);
            return arg.strValue().equals("asc");
        }
        return true;
    }
}

