/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.ArrayList;
import java.util.List;
import org.delia.compiler.ast.QueryExp;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunctionBase;
import org.delia.runner.QueryResponse;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;

public class OffsetFunction
extends QueryResponseFunctionBase {
    public OffsetFunction(DTypeRegistry registry) {
        super(registry);
    }

    @Override
    public QueryResponse process(String fnName, QueryExp queryExp, QueryResponse qresp, QueryFuncContext ctx) {
        int offset;
        if (this.dbDoesThis(ctx)) {
            return qresp;
        }
        List<DValue> dvalList = ctx.getDValList();
        if (dvalList == null || dvalList.size() <= 1) {
            return qresp;
        }
        ctx.currentOffset = offset = this.getIntArg(queryExp, ctx);
        this.doLimitAndOffset(ctx, qresp);
        return qresp;
    }

    protected boolean canExecuteInGivenOrder(QueryFuncContext ctx) {
        int pos1 = ctx.pendingTrail.getTrail().indexOf("offset");
        int pos2 = ctx.pendingTrail.getTrail().indexOf("limit");
        if (pos1 < 0 || pos2 < 0) {
            return true;
        }
        return pos1 < pos2;
    }

    protected void doLimitAndOffset(QueryFuncContext ctx, QueryResponse qresp) {
        int offset = ctx.currentOffset;
        int pgSize = ctx.currentPgSize;
        ctx.currentOffset = 0;
        if (ctx.offsetLimitDirtyFlag) {
            ctx.offsetLimitDirtyFlag = true;
            ArrayList<DValue> newlist = new ArrayList<DValue>();
            int i = 0;
            List<DValue> dvalList = ctx.getDValList();
            for (DValue dval : dvalList) {
                if (offset > 0) {
                    --offset;
                    continue;
                }
                if (i == pgSize) break;
                newlist.add(dval);
                ++i;
            }
            qresp.dvalList = newlist;
        }
    }
}

