/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.delia.compiler.ast.QueryExp;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunctionBase;
import org.delia.runner.QueryResponse;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.util.DeliaExceptionHelper;

public class MinFunction
extends QueryResponseFunctionBase {
    public MinFunction(DTypeRegistry registry) {
        super(registry);
    }

    @Override
    public QueryResponse process(String fnName, QueryExp queryExp, QueryResponse qresp, QueryFuncContext ctx) {
        if (this.dbDoesThis(ctx)) {
            return qresp;
        }
        List<DValue> dvalList = ctx.getDValList();
        if (CollectionUtils.isEmpty(dvalList)) {
            qresp.dvalList = null;
            return qresp;
        }
        Shape shape = this.detectShape(ctx);
        if (shape == null) {
            return qresp;
        }
        switch (shape) {
            case INTEGER: {
                return this.processInt(qresp, dvalList);
            }
            case LONG: {
                return this.processLong(qresp, dvalList);
            }
            case NUMBER: {
                return this.processNumber(qresp, dvalList);
            }
            case STRING: {
                return this.processString(qresp, dvalList);
            }
        }
        DeliaExceptionHelper.throwError("unsupported-min-type", "min() doesn't support type '%s'", new Object[]{shape});
        return qresp;
    }

    private QueryResponse processInt(QueryResponse qresp, List<DValue> dvalList) {
        int min = Integer.MAX_VALUE;
        for (DValue dval : dvalList) {
            int k;
            if (dval == null || (k = dval.asInt()) >= min) continue;
            min = k;
        }
        DValue dval = this.buildIntVal(min);
        this.setSingletonResult(qresp, dval);
        return qresp;
    }

    private QueryResponse processLong(QueryResponse qresp, List<DValue> dvalList) {
        long min = Long.MAX_VALUE;
        for (DValue dval : dvalList) {
            long k;
            if (dval == null || (k = dval.asLong()) >= min) continue;
            min = k;
        }
        DValue dval = this.buildLongVal(min);
        this.setSingletonResult(qresp, dval);
        return qresp;
    }

    private QueryResponse processNumber(QueryResponse qresp, List<DValue> dvalList) {
        double min = Double.MAX_VALUE;
        for (DValue dval : dvalList) {
            double k;
            if (dval == null || !((k = dval.asNumber()) < min)) continue;
            min = k;
        }
        DValue dval = this.buildNumberVal(min);
        this.setSingletonResult(qresp, dval);
        return qresp;
    }

    private QueryResponse processString(QueryResponse qresp, List<DValue> dvalList) {
        String min = null;
        for (DValue dval : dvalList) {
            if (dval == null) continue;
            String k = dval.asString();
            if (min == null) {
                min = k;
                continue;
            }
            if (k.compareTo(min) >= 0) continue;
            min = k;
        }
        DValue dval = this.buildStringVal(min);
        this.setSingletonResult(qresp, dval);
        return qresp;
    }

    private Shape detectShape(QueryFuncContext ctx) {
        List<DValue> dvalList = ctx.getDValList();
        for (DValue dval : dvalList) {
            if (dval == null) continue;
            return dval.getType().getShape();
        }
        return null;
    }
}

