/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.ArrayList;
import java.util.List;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.QueryFuncExp;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunctionBase;
import org.delia.runner.FetchRunner;
import org.delia.runner.QueryResponse;
import org.delia.type.DRelation;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DValueHelper;

public class FetchFunction
extends QueryResponseFunctionBase {
    private FetchRunner fetchRunner;

    public FetchFunction(DTypeRegistry registry, FetchRunner fetchRunner) {
        super(registry);
        this.fetchRunner = fetchRunner;
    }

    @Override
    public QueryResponse process(String fnName, QueryExp queryExp, QueryResponse qresp, QueryFuncContext ctx) {
        QueryFuncExp qfe = ctx.qfexp;
        String targetFieldName = this.getStringArg(queryExp, ctx);
        QueryResponse qresResult = new QueryResponse();
        qresResult.ok = true;
        qresResult.dvalList = new ArrayList<DValue>();
        List<DValue> dvalList = ctx.getDValList();
        ArrayList<DValue> newScopeList = new ArrayList<DValue>();
        boolean checkFieldExists = true;
        for (DValue dval : dvalList) {
            DValue inner;
            if (checkFieldExists) {
                checkFieldExists = false;
                DValueHelper.throwIfFieldNotExist("fetch", targetFieldName, dval);
            }
            if ((inner = dval.asStruct().getField(targetFieldName)) == null) continue;
            DRelation drel = inner.asRelation();
            QueryResponse qrespFetch = this.fetchRunner.load(drel, targetFieldName);
            if (!qrespFetch.ok) {
                qresResult.ok = false;
                qresResult.err = qrespFetch.err;
                continue;
            }
            qresResult.dvalList.addAll(qrespFetch.dvalList);
            newScopeList.addAll(qrespFetch.dvalList);
            drel.setFetchedItems(qrespFetch.dvalList);
        }
        QueryResponse newRes = new QueryResponse();
        newRes.ok = true;
        newRes.dvalList = newScopeList;
        ctx.scope.changeScope(newRes);
        return qresp;
    }
}

