/*
 * Decompiled with CFR 0.152.
 */
package org.delia.log;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.delia.log.LogLevel;
import org.delia.util.StringUtil;

public class LogLevelMapBuilder {
    private Map<String, LogLevel> levelMap = new TreeMap<String, LogLevel>();

    public void buildMap(List<String> levelMapList) {
        if (levelMapList == null || levelMapList.isEmpty()) {
            return;
        }
        int index = 0;
        for (String s : levelMapList) {
            String[] ar = s.split("=");
            if (ar.length != 2) continue;
            String partialClassName = ar[0];
            LogLevel level = null;
            try {
                level = LogLevel.valueOf(ar[1]);
            }
            catch (Exception e) {
                System.err.println("invalid log level line: " + ar[1]);
            }
            if (!StringUtil.hasText(partialClassName) || level == null) continue;
            String id = String.format("%03d-%s", index, partialClassName);
            this.levelMap.put(id, level);
        }
    }

    public LogLevel calcLevel(String name, LogLevel defaultLevel) {
        for (String key : this.levelMap.keySet()) {
            String partialPath = key.substring(key.indexOf(45) + 1);
            if (!name.contains(partialPath)) continue;
            return this.levelMap.get(key);
        }
        return defaultLevel;
    }
}

