/*
 * Decompiled with CFR 0.152.
 */
package org.delia.error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.delia.error.DeliaError;
import org.delia.error.ErrorCopyFilter;
import org.delia.error.ErrorTracker;
import org.delia.error.ValidationError;
import org.delia.log.Log;

public class SimpleErrorTracker
implements ErrorTracker {
    private List<DeliaError> errL = Collections.synchronizedList(new ArrayList());
    private Log log;

    public SimpleErrorTracker(Log log) {
        this.log = log;
    }

    @Override
    public int errorCount() {
        return this.errL.size();
    }

    @Override
    public boolean areNoErrors() {
        return this.errL.isEmpty();
    }

    @Override
    public void add(Object self, DeliaError err) {
        if (self != null && err.getSourceClass() == null) {
            err.setSourceClass(self.getClass());
        }
        this.errL.add(err);
        String s = err.toString();
        String errType = err instanceof ValidationError ? "VALERROR" : "ERROR";
        this.log.logError("%s: %s", errType, s);
    }

    @Override
    public void add(DeliaError err) {
        this.add(null, err);
    }

    @Override
    public void clear() {
        this.errL.clear();
    }

    @Override
    public DeliaError add(Object self, String id, String msg) {
        DeliaError err = new DeliaError(id, msg, null);
        this.add(self, err);
        return err;
    }

    @Override
    public DeliaError add(String id, String msg) {
        DeliaError err = new DeliaError(id, msg, null);
        this.add(err);
        return err;
    }

    @Override
    public void dump() {
        ArrayList<DeliaError> already = new ArrayList<DeliaError>();
        for (DeliaError err : this.errL) {
            if (already.contains(err)) continue;
            String s = err.toString();
            if (err instanceof ValidationError) {
                this.log.log("VALERROR: %s", s);
            } else {
                this.log.log("ERROR: %s", s);
            }
            already.add(err);
        }
    }

    @Override
    public List<DeliaError> getErrors() {
        return this.errL;
    }

    public List<DeliaError> getErrorsSinceMark(int mark) {
        ArrayList<DeliaError> list = new ArrayList<DeliaError>();
        for (int i = mark; i < this.errL.size(); ++i) {
            list.add(this.errL.get(i));
        }
        return list;
    }

    @Override
    public void copyErrorsFrom(ErrorTracker et, ErrorCopyFilter filter) {
        switch (filter) {
            case ALL: {
                this.errL.addAll(et.getErrors());
                break;
            }
            case VALIDATION_ERRORS_ONLY: {
                for (ValidationError err : et.getValidationErrors()) {
                    this.errL.add(err);
                }
                break;
            }
            case PLAT_ERRORS_ONLY: {
                for (DeliaError err : et.getErrors()) {
                    if (err instanceof ValidationError) continue;
                    this.errL.add(err);
                }
                break;
            }
        }
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        ArrayList<ValidationError> list = new ArrayList<ValidationError>();
        for (DeliaError err : this.errL) {
            if (!(err instanceof ValidationError)) continue;
            list.add((ValidationError)err);
        }
        return list;
    }

    @Override
    public DeliaError getLastError() {
        if (this.errL.isEmpty()) {
            return null;
        }
        return this.errL.get(this.errL.size() - 1);
    }
}

