/*
 * Decompiled with CFR 0.152.
 */
package org.delia.error;

import java.util.Locale;
import java.util.ResourceBundle;
import org.delia.error.DeliaError;
import org.delia.error.ErrorFormatterService;
import org.delia.error.ValidationError;
import org.delia.log.Log;
import org.delia.log.LogLevel;
import org.delia.util.StringUtil;

public class ErrorFormatterServiceImpl
implements ErrorFormatterService {
    private Log logger;
    private String currentBundlePath;
    private ResourceBundle currentBundle;

    public ErrorFormatterServiceImpl(Log log) {
        this.logger = log;
    }

    @Override
    public String format(DeliaError err) {
        return this.format(err, Locale.getDefault());
    }

    @Override
    public String format(DeliaError err, Locale locale) {
        String src = err.getSourceClass() == null ? "?" : err.getSourceClass().getName();
        String dateStr = err.getTimestamp().toString();
        String textMessage = this.getTextMessage(err, locale);
        String s = String.format("%s: [%s] - (%s) %s - %s", dateStr, err.getId(), err.getArea(), src, textMessage);
        return s;
    }

    protected synchronized String getTextMessage(DeliaError err, Locale locale) {
        String textMessage = err.getMsg();
        String bundlePath = "";
        if (StringUtil.hasText(bundlePath)) {
            if (!bundlePath.equals(this.currentBundlePath)) {
                try {
                    ResourceBundle bundle;
                    this.logger.log("loading resource bundle '%s'", bundlePath);
                    this.currentBundle = bundle = ResourceBundle.getBundle(bundlePath, locale);
                    this.currentBundlePath = bundlePath;
                }
                catch (Exception e) {
                    String errmsg = String.format("failed to load resource bundle '%s'", bundlePath);
                    this.logger.logException(LogLevel.ERROR, errmsg, e);
                }
            }
            if (this.currentBundle != null && this.currentBundle.containsKey(err.getId())) {
                textMessage = this.currentBundle.getString(err.getId());
            }
        }
        return textMessage;
    }

    @Override
    public String formatValidationError(ValidationError err) {
        return this.formatValidationError(err, Locale.getDefault());
    }

    @Override
    public String formatValidationError(ValidationError err, Locale locale) {
        String textMessage = this.getTextMessage(err, locale);
        String s = String.format("%s", textMessage);
        return s;
    }
}

