/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql.prepared;

import java.util.ArrayList;
import java.util.StringJoiner;
import org.apache.commons.collections.CollectionUtils;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.QueryFieldExp;
import org.delia.compiler.ast.QueryFuncExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.QuerySpec;
import org.delia.db.sql.StrCreator;
import org.delia.type.BuiltInTypes;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;

public class SelectFuncHelper
extends ServiceBase {
    protected DTypeRegistry registry;

    public SelectFuncHelper(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
    }

    public DType getSelectResultType(QuerySpec spec) {
        if (this.isCountPresent(spec)) {
            return this.registry.getType(BuiltInTypes.LONG_SHAPE);
        }
        if (this.isExistsPresent(spec)) {
            return this.registry.getType(BuiltInTypes.LONG_SHAPE);
        }
        if (this.isMinPresent(spec)) {
            return this.determineFieldTypeForFn(spec, "min");
        }
        if (this.isMaxPresent(spec)) {
            return this.determineFieldTypeForFn(spec, "max");
        }
        String typeName = spec.queryExp.getTypeName();
        DStructType dtype = this.registry.findTypeOrSchemaVersionType(typeName);
        return dtype;
    }

    protected DType determineFieldTypeForFn(QuerySpec spec, String fnName) {
        String fieldName;
        QueryFieldExp fieldExp = this.findFieldUsingFn(spec, fnName);
        String typeName = spec.queryExp.getTypeName();
        DStructType dtype = this.registry.findTypeOrSchemaVersionType(typeName);
        DType fieldType = DValueHelper.findFieldType(dtype, fieldName = fieldExp.funcName);
        if (fieldType == null) {
            DeliaExceptionHelper.throwError("unknown-field", "%s - can't find field '%s' in type '%s'", fnName, fieldName, typeName);
        }
        return fieldType;
    }

    public void doOrderByIfPresent(StrCreator sc, QuerySpec spec, String typeName) {
        QueryFuncExp qfexp = this.findFn(spec, "orderBy");
        if (qfexp == null) {
            return;
        }
        this.doInnerOrderBy(sc, spec, typeName, qfexp);
    }

    public void doInnerOrderBy(StrCreator sc, QuerySpec spec, String typeName, QueryFuncExp qfexp) {
        DStructType structType = (DStructType)this.registry.getType(typeName);
        StringJoiner joiner = new StringJoiner(",");
        boolean isDesc = false;
        for (Exp exp : qfexp.argL) {
            if (exp instanceof IdentExp) {
                isDesc = exp.strValue().equals("desc");
                continue;
            }
            String fieldName = exp.strValue();
            if (!DValueHelper.fieldExists(structType, fieldName)) {
                DeliaExceptionHelper.throwError("unknown-field", "type '%s' does not have field '%s'. Invalid orderBy parameter", typeName, fieldName);
            }
            joiner.add(exp.strValue());
        }
        String s = String.format(" ORDER BY %s", joiner.toString());
        sc.o(s, new String[0]);
        if (isDesc) {
            sc.o(" DESC", new String[0]);
        }
    }

    public void doOffsetIfPresent(StrCreator sc, QuerySpec spec, String typeName) {
        QueryFuncExp qfexp = this.findFn(spec, "offset");
        if (qfexp == null) {
            return;
        }
        IntegerExp exp = (IntegerExp)qfexp.argL.get(0);
        Integer n = exp.val;
        String s = String.format(" OFFSET %d", n);
        sc.o(s, new String[0]);
    }

    public void doLimitIfPresent(StrCreator sc, QuerySpec spec, String typeName) {
        QueryFuncExp qfexp = this.findFn(spec, "limit");
        if (qfexp == null) {
            return;
        }
        IntegerExp exp = (IntegerExp)qfexp.argL.get(0);
        Integer n = exp.val;
        String s = String.format(" LIMIT %d", n);
        sc.o(s, new String[0]);
    }

    public QuerySpec doFirstFixup(QuerySpec specOriginal, String typeName) {
        QuerySpec spec = this.doLastFixup(specOriginal, typeName);
        QueryFuncExp limitFn = this.findFn(spec, "limit");
        if (limitFn != null) {
            spec.queryExp.qfelist.remove(limitFn);
        }
        QueryFuncExp qfexp1 = new QueryFuncExp(99, new IdentExp("limit"), null, false);
        qfexp1.argL.add(new IntegerExp((Integer)1));
        spec.queryExp.qfelist.add(qfexp1);
        return spec;
    }

    public QuerySpec doLastFixup(QuerySpec specOriginal, String typeName) {
        DStructType dtype = this.registry.findTypeOrSchemaVersionType(typeName);
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(dtype);
        if (pair == null) {
            DeliaExceptionHelper.throwError("last-requires-sortable-field", "last() requires an orderBy() function or a primary key in type '%s'", typeName);
            return null;
        }
        QuerySpec spec = this.makeCopy(specOriginal);
        QueryFuncExp qfexp1 = new QueryFuncExp(99, new IdentExp("orderBy"), null, false);
        QueryFieldExp qfe = new QueryFieldExp(99, new IdentExp(pair.name));
        IdentExp exp1 = new IdentExp("desc");
        qfexp1.argL.add(qfe);
        qfexp1.argL.add(exp1);
        QueryFuncExp qfexpAlreadyInList = this.findFn(spec, "last");
        int index = 0;
        boolean done = false;
        for (QueryFuncExp qfexp : spec.queryExp.qfelist) {
            if (index < spec.queryExp.qfelist.size() - 1 && qfexp == qfexpAlreadyInList) {
                spec.queryExp.qfelist.add(index, qfexp1);
                done = true;
                break;
            }
            ++index;
        }
        if (!done) {
            spec.queryExp.qfelist.add(qfexp1);
        }
        return spec;
    }

    protected QuerySpec makeCopy(QuerySpec spec) {
        QuerySpec copy = new QuerySpec();
        copy.evaluator = spec.evaluator;
        QueryExp qfe = spec.queryExp;
        ArrayList<QueryFuncExp> qfelist = new ArrayList<QueryFuncExp>();
        qfelist.addAll(qfe.qfelist);
        copy.queryExp = new QueryExp(qfe.pos, new IdentExp(qfe.typeName), qfe.filter, null);
        copy.queryExp.qfelist = qfelist;
        return copy;
    }

    public boolean isOrderByPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "orderBy");
        return qfexp != null;
    }

    public boolean isCountPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "count");
        return qfexp != null;
    }

    public boolean isExistsPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "exist");
        return qfexp != null;
    }

    public boolean isMinPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "min");
        return qfexp != null;
    }

    public boolean isMaxPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "max");
        return qfexp != null;
    }

    public boolean isFirstPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "first");
        return qfexp != null;
    }

    public boolean isLastPresent(QuerySpec spec) {
        QueryFuncExp qfexp = this.findFn(spec, "last");
        return qfexp != null;
    }

    protected QueryFuncExp findFn(QuerySpec spec, String targetFnName) {
        QueryExp queryExp = spec.queryExp;
        if (CollectionUtils.isNotEmpty(queryExp.qfelist)) {
            for (QueryFuncExp qfexp : queryExp.qfelist) {
                String fnName;
                if (qfexp instanceof QueryFieldExp || !(fnName = qfexp.funcName).equals(targetFnName)) continue;
                return qfexp;
            }
        }
        return null;
    }

    public String findFieldNameUsingFn(QuerySpec spec, String targetFnName) {
        QueryFieldExp prev = this.findFieldUsingFn(spec, targetFnName);
        if (prev == null) {
            return null;
        }
        this.determineFieldTypeForFn(spec, targetFnName);
        return prev.funcName;
    }

    protected QueryFieldExp findFieldUsingFn(QuerySpec spec, String targetFnName) {
        QueryExp queryExp = spec.queryExp;
        QueryFieldExp prev = null;
        if (CollectionUtils.isNotEmpty(queryExp.qfelist)) {
            for (QueryFuncExp qfexp : queryExp.qfelist) {
                if (qfexp instanceof QueryFieldExp) {
                    prev = (QueryFieldExp)qfexp;
                    continue;
                }
                String fnName = qfexp.funcName;
                if (!fnName.equals(targetFnName)) continue;
                return prev;
            }
        }
        return null;
    }
}

