/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql.prepared;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.delia.compiler.ast.QueryExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBAccessContext;
import org.delia.db.QuerySpec;
import org.delia.db.h2.DBListingType;
import org.delia.db.h2.SqlHelperFactory;
import org.delia.db.sql.SqlNameFormatter;
import org.delia.db.sql.StrCreator;
import org.delia.db.sql.prepared.InsertStatementGenerator;
import org.delia.db.sql.prepared.SelectFuncHelper;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.db.sql.prepared.WhereClauseGenerator;
import org.delia.db.sql.table.TableInfo;
import org.delia.runner.VarEvaluator;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;

public class PreparedStatementGenerator
extends ServiceBase {
    protected DTypeRegistry registry;
    protected SqlNameFormatter nameFormatter;
    protected WhereClauseGenerator pwheregen;
    protected SelectFuncHelper selectFnHelper;
    protected SqlHelperFactory sqlHelperFactory;
    private VarEvaluator varEvaluator;

    public PreparedStatementGenerator(FactoryService factorySvc, DTypeRegistry registry, SqlHelperFactory sqlHelperFactory, VarEvaluator varEvaluator) {
        super(factorySvc);
        this.registry = registry;
        this.sqlHelperFactory = sqlHelperFactory;
        this.varEvaluator = varEvaluator;
        DBAccessContext dbctx = new DBAccessContext(registry, varEvaluator);
        this.nameFormatter = sqlHelperFactory.createNameFormatter(dbctx);
        this.pwheregen = sqlHelperFactory.createPWhereGen(dbctx);
        this.selectFnHelper = sqlHelperFactory.createSelectFuncHelper(dbctx);
    }

    public SqlStatement generateQuery(QuerySpec spec) {
        String fieldName;
        StrCreator sc = new StrCreator();
        QueryExp exp = spec.queryExp;
        String typeName = exp.getTypeName();
        if (this.selectFnHelper.isCountPresent(spec) || this.selectFnHelper.isExistsPresent(spec)) {
            sc.o("SELECT COUNT(*) FROM %s", typeName);
        } else if (this.selectFnHelper.isMinPresent(spec)) {
            fieldName = this.selectFnHelper.findFieldNameUsingFn(spec, "min");
            sc.o("SELECT MIN(%s) FROM %s", fieldName, typeName);
        } else if (this.selectFnHelper.isMaxPresent(spec)) {
            fieldName = this.selectFnHelper.findFieldNameUsingFn(spec, "max");
            sc.o("SELECT MAX(%s) FROM %s", fieldName, typeName);
        } else if (this.selectFnHelper.isFirstPresent(spec)) {
            sc.o("SELECT TOP 1 * FROM %s", typeName);
        } else if (this.selectFnHelper.isLastPresent(spec)) {
            spec = this.doSelectLast(sc, spec, typeName);
        } else {
            sc.o("SELECT * FROM %s", typeName);
        }
        SqlStatement statement = new SqlStatement();
        statement = this.pwheregen.generateAWhere(spec);
        sc.o(statement.sql, new String[0]);
        this.generateQueryFns(sc, spec, typeName);
        sc.o(";", new String[0]);
        statement.sql = sc.str;
        return statement;
    }

    protected QuerySpec doSelectLast(StrCreator sc, QuerySpec spec, String typeName) {
        sc.o("SELECT TOP 1 * FROM %s", typeName);
        if (this.selectFnHelper.isOrderByPresent(spec)) {
            return spec;
        }
        return this.selectFnHelper.doLastFixup(spec, typeName);
    }

    protected void generateQueryFns(StrCreator sc, QuerySpec spec, String typeName) {
        this.selectFnHelper.doOrderByIfPresent(sc, spec, typeName);
        this.selectFnHelper.doLimitIfPresent(sc, spec, typeName);
        this.selectFnHelper.doOffsetIfPresent(sc, spec, typeName);
    }

    public SqlStatement generateDelete(QuerySpec spec) {
        StrCreator sc = new StrCreator();
        sc.o("DELETE FROM %s", this.tblName(spec.queryExp.getTypeName()));
        SqlStatement statement = this.pwheregen.generateAWhere(spec);
        sc.o(statement.sql, new String[0]);
        sc.o(";", new String[0]);
        statement.sql = sc.str;
        return statement;
    }

    protected String tblName(String typeName) {
        return this.nameFormatter.convert(typeName);
    }

    public SqlStatement generateUpdate(DValue dval, List<TableInfo> tblInfoL, QuerySpec spec) {
        HashMap<String, DRelation> map = new HashMap<String, DRelation>();
        SqlStatement statement = new SqlStatement();
        String sql = this.doGenerateUpdate(dval, map, statement);
        if (sql.isEmpty()) {
            statement.sql = "";
            return statement;
        }
        SqlStatement st2 = this.generateQuery(spec);
        statement.paramL.addAll(st2.paramL);
        int pos = st2.sql.indexOf("WHERE ");
        if (pos > 0) {
            String query = st2.sql.substring(pos);
            statement.sql = String.format("%s %s", sql, query);
        } else {
            statement.sql = sql;
        }
        return statement;
    }

    protected String doGenerateUpdate(DValue dval, Map<String, DRelation> map, SqlStatement statement) {
        DStructType dtype = (DStructType)dval.getType();
        StrCreator sc = new StrCreator();
        sc.o("UPDATE %s SET ", this.tblName(dtype));
        InsertStatementGenerator insgen = new InsertStatementGenerator(this.factorySvc, this.registry, this.nameFormatter);
        String s = insgen.generateUpdateBody(sc, dval, map, statement);
        return s;
    }

    protected String tblName(DType dtype) {
        return this.nameFormatter.convert(dtype);
    }

    public String generateTableDetect(String tableName) {
        StrCreator sc = new StrCreator();
        sc.o("SELECT EXISTS ( ", new String[0]);
        sc.o(" SELECT FROM information_schema.tables", new String[0]);
        boolean b = false;
        if (b) {
            sc.o(" WHERE  table_schema = '%s'", "PUBLIC");
            sc.o(" AND    table_name   = '%s' )", this.tblName(tableName));
        } else {
            sc.o(" WHERE    table_name   = '%s' )", this.tblName(tableName));
        }
        return sc.str;
    }

    public String generateSchemaListing(DBListingType listingType) {
        StrCreator sc = new StrCreator();
        switch (listingType) {
            case ALL_TABLES: {
                sc.o("SELECT * FROM information_schema.tables", new String[0]);
                boolean b = true;
                if (!b) break;
                sc.o(" WHERE  table_schema = '%s'", "PUBLIC");
                break;
            }
            case ALL_CONSTRAINTS: {
                sc.o("SELECT * FROM information_schema.constraints", new String[0]);
                boolean b = true;
                if (!b) break;
                sc.o(" WHERE  table_schema = '%s'", "PUBLIC");
            }
        }
        return sc.str;
    }

    public String generateFieldDetect(String tableName, String fieldName) {
        StrCreator sc = new StrCreator();
        sc.o("SELECT EXISTS ( ", new String[0]);
        sc.o(" SELECT FROM information_schema.columns", new String[0]);
        boolean b = false;
        if (b) {
            sc.o(" WHERE  table_schema = '%s'", "PUBLIC");
            sc.o(" AND    table_name   = '%s' ", this.tblName(tableName));
            sc.o(" AND    column_name   = '%s' )", this.tblName(fieldName));
        } else {
            sc.o(" WHERE    table_name   = '%s' ", this.tblName(tableName));
            sc.o(" AND    column_name   = '%s' )", this.tblName(fieldName));
        }
        return sc.str;
    }
}

