/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.schema;

import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBInterface;
import org.delia.db.schema.AlwaysNoMigrationPolicy;
import org.delia.db.schema.AlwaysYesMigrationPolicy;
import org.delia.db.schema.MigrationPlan;
import org.delia.db.schema.MigrationPolicy;
import org.delia.db.schema.SafeMigrationPolicy;
import org.delia.db.schema.SchemaMigrator;
import org.delia.db.schema.SchemaType;
import org.delia.runner.VarEvaluator;
import org.delia.type.DTypeRegistry;

public class MigrationService
extends ServiceBase {
    private DBInterface dbInterface;
    private MigrationPolicy policy;

    public MigrationService(DBInterface dbInterface, FactoryService factorySvc) {
        super(factorySvc);
        this.dbInterface = dbInterface;
        this.factorySvc = factorySvc;
        this.policy = new SafeMigrationPolicy();
    }

    public boolean autoMigrateDbIfNeeded(DTypeRegistry registry, VarEvaluator varEvaluator) {
        SchemaMigrator migrator = this.factorySvc.createSchemaMigrator(this.dbInterface, registry, varEvaluator);
        migrator.createSchemaTableIfNeeded();
        boolean b = migrator.dbNeedsMigration();
        this.log.logDebug("MIGRATION needed: %b", b);
        if (b) {
            MigrationPlan plan = migrator.generateMigrationPlan();
            if (this.policy.shouldMigrationOccur(plan)) {
                boolean performRiskChecks = this.policy.shouldPerformRiskChecks();
                b = migrator.performMigrations(performRiskChecks);
                if (!b) {
                    return false;
                }
            } else {
                this.log.logError("MIGRATION rejected due to policy : %s", this.policy.getClass().getSimpleName());
                this.log.log("=== MIGRATION PLAN ===", new Object[0]);
                for (SchemaType ss : plan.diffL) {
                    this.log.log(ss.getSummary(), new Object[0]);
                }
                this.log.log("=== END MIGRATION PLAN ===", new Object[0]);
                migrator.close();
                return false;
            }
        }
        migrator.close();
        return true;
    }

    public MigrationPlan createMigrationPlan(DTypeRegistry registry, VarEvaluator varEvaluator) {
        SchemaMigrator migrator = this.factorySvc.createSchemaMigrator(this.dbInterface, registry, varEvaluator);
        migrator.createSchemaTableIfNeeded();
        boolean b = migrator.dbNeedsMigration();
        this.log.log("MIGRATION PLAN: %b", b);
        MigrationPlan plan = migrator.generateMigrationPlan();
        migrator.close();
        return plan;
    }

    public MigrationPlan runMigrationPlan(DTypeRegistry registry, MigrationPlan plan, VarEvaluator varEvaluator) {
        SchemaMigrator migrator = this.factorySvc.createSchemaMigrator(this.dbInterface, registry, varEvaluator);
        migrator.createSchemaTableIfNeeded();
        boolean b = migrator.dbNeedsMigration();
        this.log.log("RUN MIGRATION PLAN: %b", b);
        plan = migrator.runMigrationPlan(plan);
        migrator.close();
        return plan;
    }

    public void initPolicy(boolean useSafeMigrationPolicy, boolean enableAutomaticMigrations) {
        this.policy = !enableAutomaticMigrations ? new AlwaysNoMigrationPolicy() : (useSafeMigrationPolicy ? new SafeMigrationPolicy() : new AlwaysYesMigrationPolicy());
    }
}

