/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.postgres;

import org.delia.compiler.ast.QueryExp;
import org.delia.core.FactoryService;
import org.delia.db.QuerySpec;
import org.delia.db.h2.SqlHelperFactory;
import org.delia.db.sql.StrCreator;
import org.delia.db.sql.prepared.PreparedStatementGenerator;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.runner.VarEvaluator;
import org.delia.type.DTypeRegistry;

public class PostgresPreparedStatementGenerator
extends PreparedStatementGenerator {
    public PostgresPreparedStatementGenerator(FactoryService factorySvc, DTypeRegistry registry, SqlHelperFactory sqlHelperFactory, VarEvaluator varEvaluator) {
        super(factorySvc, registry, sqlHelperFactory, varEvaluator);
    }

    @Override
    public SqlStatement generateQuery(QuerySpec spec) {
        String fieldName;
        StrCreator sc = new StrCreator();
        QueryExp exp = spec.queryExp;
        String typeName = exp.getTypeName();
        if (this.selectFnHelper.isCountPresent(spec) || this.selectFnHelper.isExistsPresent(spec)) {
            sc.o("SELECT COUNT(*) FROM %s", typeName);
        } else if (this.selectFnHelper.isMinPresent(spec)) {
            fieldName = this.selectFnHelper.findFieldNameUsingFn(spec, "min");
            sc.o("SELECT MIN(%s) FROM %s", fieldName, typeName);
        } else if (this.selectFnHelper.isMaxPresent(spec)) {
            fieldName = this.selectFnHelper.findFieldNameUsingFn(spec, "max");
            sc.o("SELECT MAX(%s) FROM %s", fieldName, typeName);
        } else if (this.selectFnHelper.isFirstPresent(spec)) {
            spec = this.doSelectFirst(sc, spec, typeName);
        } else if (this.selectFnHelper.isLastPresent(spec)) {
            spec = this.doSelectLast(sc, spec, typeName);
        } else {
            sc.o("SELECT * FROM %s", typeName);
        }
        SqlStatement statement = new SqlStatement();
        statement = this.pwheregen.generateAWhere(spec);
        sc.o(statement.sql, new String[0]);
        this.generateQueryFns(sc, spec, typeName);
        sc.o(";", new String[0]);
        statement.sql = sc.str;
        return statement;
    }

    protected QuerySpec doSelectFirst(StrCreator sc, QuerySpec spec, String typeName) {
        sc.o("SELECT * FROM %s", typeName);
        return this.selectFnHelper.doFirstFixup(spec, typeName);
    }

    @Override
    protected QuerySpec doSelectLast(StrCreator sc, QuerySpec spec, String typeName) {
        sc.o("SELECT * FROM %s", typeName);
        if (this.selectFnHelper.isOrderByPresent(spec)) {
            return spec;
        }
        return this.selectFnHelper.doLastFixup(spec, typeName);
    }
}

