/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter.filterfn;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.compiler.astx.XNAFSingleExp;
import org.delia.error.DeliaError;
import org.delia.runner.DeliaException;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DateUtils;
import org.delia.valuebuilder.ScalarValueBuilder;

public class FilterFnRunner {
    private DTypeRegistry registry;

    public FilterFnRunner(DTypeRegistry registry) {
        this.registry = registry;
    }

    public boolean isDateFn(String fnName) {
        List<String> allFns = Arrays.asList("year", "month", "day", "hour", "minute", "second");
        return allFns.contains(fnName);
    }

    public DValue executeFilterFn(XNAFMultiExp multiexp, DValue fieldval) {
        String fnName;
        XNAFSingleExp exp = multiexp.qfeL.get(1);
        switch (fnName = exp.funcName) {
            case "year": {
                return this.execYear(multiexp, fieldval);
            }
            case "month": {
                return this.execMonth(multiexp, fieldval);
            }
            case "day": {
                return this.execDate(multiexp, fieldval);
            }
            case "hour": {
                return this.execHour(multiexp, fieldval);
            }
            case "minute": {
                return this.execMinute(multiexp, fieldval);
            }
            case "second": {
                return this.execSecond(multiexp, fieldval);
            }
        }
        DeliaError err = new DeliaError("filterfn-unknown", String.format("unknown filterfn '%s'", fnName));
        throw new DeliaException(err);
    }

    private DValue execMinute(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getMinute();
        return this.buildIntDVal(n);
    }

    private DValue execSecond(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getSecond();
        return this.buildIntDVal(n);
    }

    private DValue execHour(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getHour();
        return this.buildIntDVal(n);
    }

    private DValue execMonth(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getMonthValue();
        return this.buildIntDVal(n);
    }

    private DValue execYear(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getYear();
        return this.buildIntDVal(n);
    }

    private DValue execDate(XNAFMultiExp multiexp, DValue fieldval) {
        LocalDateTime ldt = this.convertDate(fieldval);
        int n = ldt.getDayOfMonth();
        return this.buildIntDVal(n);
    }

    private DValue buildIntDVal(int n) {
        ScalarValueBuilder builder = new ScalarValueBuilder(null, this.registry);
        return builder.buildInt(n);
    }

    private LocalDateTime convertDate(DValue fieldval) {
        Date dt = fieldval.asDate();
        LocalDateTime ldt = DateUtils.convertToUTCLocalTime(dt);
        return ldt;
    }
}

