/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.StringExp;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluatorBase;
import org.delia.type.DValue;

public class StringOpEvaluator
extends OpEvaluatorBase {
    public StringOpEvaluator(OP op, String fieldName) {
        super(op, fieldName);
    }

    @Override
    protected boolean doMatch(Object left) {
        DValue dval = (DValue)left;
        if (this.op != OP.LIKE) {
            Boolean b = true;
            b = this.checkNull(dval, this.rightVar);
            if (b != null) {
                return b;
            }
        } else if (dval.asStruct().getField(this.fieldName) == null) {
            return false;
        }
        String s1 = this.getFieldValue(dval).asString();
        String s2 = ((StringExp)this.rightVar).strValue();
        switch (this.op) {
            case LT: {
                return s1.compareTo(s2) < 0;
            }
            case LE: {
                return s1.compareTo(s2) <= 0;
            }
            case GT: {
                return s1.compareTo(s2) > 0;
            }
            case GE: {
                return s1.compareTo(s2) >= 0;
            }
            case EQ: {
                return s1.compareTo(s2) == 0;
            }
            case NEQ: {
                return s1.compareTo(s2) != 0;
            }
            case LIKE: {
                return this.doLike(s1, s2);
            }
        }
        return false;
    }

    private boolean doLike(String s1, String s2) {
        boolean wildStart = s2.startsWith("%");
        boolean wildEnd = s2.endsWith("%");
        if (wildStart) {
            s2 = s2.substring(1, s2.length());
        }
        if (wildEnd) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if (wildStart && wildEnd) {
            return s1.contains(s2);
        }
        if (wildStart) {
            return s1.endsWith(s2);
        }
        if (wildEnd) {
            return s1.startsWith(s2);
        }
        return s1.contains(s2);
    }
}

