/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.IntegerExp;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluatorBase;
import org.delia.type.DRelation;
import org.delia.type.DValue;

public class RelationOpEvaluator
extends OpEvaluatorBase {
    public RelationOpEvaluator(OP op, String fieldName) {
        super(op, fieldName);
    }

    @Override
    protected boolean doMatch(Object left) {
        DValue dval = (DValue)left;
        Boolean b = this.checkNull(dval, this.rightVar);
        if (b != null) {
            return b;
        }
        DRelation drel1 = dval.asStruct().getField(this.fieldName).asRelation();
        if (drel1.isMultipleKey()) {
            for (DValue kk : drel1.getMultipleKeys()) {
                if (!this.doInnerMatch(kk)) continue;
                return true;
            }
            return false;
        }
        DValue keyVal = drel1.getForeignKey();
        return this.doInnerMatch(keyVal);
    }

    private boolean doInnerMatch(DValue keyVal) {
        Integer n1 = keyVal.asInt();
        Integer n2 = ((IntegerExp)this.rightVar).val;
        switch (this.op) {
            case LT: {
                return n1.compareTo(n2) < 0;
            }
            case LE: {
                return n1.compareTo(n2) <= 0;
            }
            case GT: {
                return n1.compareTo(n2) > 0;
            }
            case GE: {
                return n1.compareTo(n2) >= 0;
            }
            case EQ: {
                return n1.compareTo(n2) == 0;
            }
            case NEQ: {
                return n1.compareTo(n2) != 0;
            }
        }
        return false;
    }
}

