/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.NullExp;
import org.delia.db.InternalException;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluator;
import org.delia.error.DeliaError;
import org.delia.type.DValue;
import org.delia.util.DValueHelper;

public abstract class OpEvaluatorBase
implements OpEvaluator {
    public static final String SCALAR_VAL = "__SCALAR__";
    protected String fieldName;
    protected OP op;
    protected Object rightVar;
    protected boolean negFlag;

    public OpEvaluatorBase(OP op, String fieldName) {
        this.op = op;
        this.fieldName = fieldName;
    }

    protected Boolean checkNull(DValue dval, Object right) {
        if (this.fieldName.equals(SCALAR_VAL)) {
            return null;
        }
        this.throwIfNotFieldName(dval);
        if (dval.asStruct().getField(this.fieldName) == null) {
            return right instanceof NullExp;
        }
        if (right instanceof NullExp) {
            return false;
        }
        return null;
    }

    private void throwIfNotFieldName(DValue dval) {
        if (dval == null || !dval.getType().isStructShape()) {
            return;
        }
        if (!DValueHelper.fieldExists(dval.getType(), this.fieldName)) {
            String msg = String.format("Type '%s' doesn't have field '%s'", dval.getType().getName(), this.fieldName);
            DeliaError err = new DeliaError("memdb-unknown-field", msg, null);
            throw new InternalException(err);
        }
    }

    protected DValue getFieldValue(DValue dval) {
        if (this.fieldName.equals(SCALAR_VAL)) {
            return dval;
        }
        this.throwIfNotFieldName(dval);
        return dval.asStruct().getField(this.fieldName);
    }

    @Override
    public boolean match(Object left) {
        boolean b = this.doMatch(left);
        if (this.negFlag) {
            return !b;
        }
        return b;
    }

    protected abstract boolean doMatch(Object var1);

    @Override
    public void setRightVar(Object rightVar) {
        this.rightVar = rightVar;
    }

    @Override
    public void setNegFlag(boolean negFlag) {
        this.negFlag = negFlag;
    }
}

