/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.NumberExp;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluatorBase;
import org.delia.type.DValue;

public class NumberOpEvaluator
extends OpEvaluatorBase {
    public NumberOpEvaluator(OP op, String fieldName) {
        super(op, fieldName);
    }

    @Override
    protected boolean doMatch(Object left) {
        DValue dval = (DValue)left;
        Boolean b = this.checkNull(dval, this.rightVar);
        if (b != null) {
            return b;
        }
        Double n1 = this.getFieldValue(dval).asNumber();
        Double n2 = this.rightVar instanceof IntegerExp ? Double.valueOf(((IntegerExp)this.rightVar).val.doubleValue()) : (this.rightVar instanceof LongExp ? Double.valueOf(((LongExp)this.rightVar).val.doubleValue()) : ((NumberExp)this.rightVar).val);
        switch (this.op) {
            case LT: {
                return n1.compareTo(n2) < 0;
            }
            case LE: {
                return n1.compareTo(n2) <= 0;
            }
            case GT: {
                return n1.compareTo(n2) > 0;
            }
            case GE: {
                return n1.compareTo(n2) >= 0;
            }
            case EQ: {
                return n1.compareTo(n2) == 0;
            }
            case NEQ: {
                return n1.compareTo(n2) != 0;
            }
        }
        return false;
    }
}

