/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluator;
import org.delia.error.DeliaError;
import org.delia.runner.DeliaException;
import org.delia.type.DValue;

public class NullOpEvaluator
implements OpEvaluator {
    private String fieldName;
    private OP op;
    private Object rightVar;

    public NullOpEvaluator(OP op, String fieldName) {
        this.op = op;
        this.fieldName = fieldName;
    }

    @Override
    public boolean match(Object left) {
        DValue dval = (DValue)left;
        String s1 = dval.asStruct().getField(this.fieldName).asString();
        if (this.op.equals("=")) {
            return s1 == null;
        }
        if (this.op.equals("!=")) {
            return s1 != null;
        }
        String msg = String.format("Can't use null with %s operand", new Object[]{this.op});
        DeliaError err = new DeliaError("null-not-allowed-here", msg, null);
        throw new DeliaException(err);
    }

    @Override
    public void setRightVar(Object rightVar) {
        this.rightVar = rightVar;
    }

    @Override
    public void setNegFlag(boolean negFlag) {
    }
}

