/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluatorBase;
import org.delia.type.DValue;

public class LongOpEvaluator
extends OpEvaluatorBase {
    public LongOpEvaluator(OP op, String fieldName) {
        super(op, fieldName);
    }

    @Override
    protected boolean doMatch(Object left) {
        DValue dval = (DValue)left;
        Boolean b = this.checkNull(dval, this.rightVar);
        if (b != null) {
            return b;
        }
        Long n1 = this.getFieldValue(dval).asLong();
        Long n2 = this.rightVar instanceof IntegerExp ? Long.valueOf(((IntegerExp)this.rightVar).val.longValue()) : ((LongExp)this.rightVar).val;
        switch (this.op) {
            case LT: {
                return n1.compareTo(n2) < 0;
            }
            case LE: {
                return n1.compareTo(n2) <= 0;
            }
            case GT: {
                return n1.compareTo(n2) > 0;
            }
            case GE: {
                return n1.compareTo(n2) >= 0;
            }
            case EQ: {
                return n1.compareTo(n2) == 0;
            }
            case NEQ: {
                return n1.compareTo(n2) != 0;
            }
        }
        return false;
    }
}

