/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.FilterOpFullExp;
import org.delia.compiler.ast.ListExp;
import org.delia.compiler.ast.QueryInExp;
import org.delia.db.memdb.filter.OpEvaluator;
import org.delia.type.DStructType;
import org.delia.type.DValue;

public class InEvaluator
implements OpEvaluator {
    private FilterOpFullExp fullExp;
    private DStructType dtype;
    private QueryInExp inExp;
    private String keyField;

    public InEvaluator(FilterOpFullExp fullexp, DStructType dtype) {
        this.fullExp = fullexp;
        this.dtype = dtype;
        this.inExp = (QueryInExp)fullexp.opexp1;
        this.keyField = this.inExp.fieldName;
        if (this.keyField == null) {
            // empty if block
        }
    }

    @Override
    public boolean match(Object left) {
        boolean b = this.doMatch(left);
        if (this.fullExp.negFlag) {
            return !b;
        }
        return b;
    }

    private boolean doMatch(Object left) {
        if (this.keyField == null) {
            return false;
        }
        DValue dval = (DValue)left;
        DValue key = dval.asStruct().getField(this.keyField);
        if (key == null) {
            return false;
        }
        return this.isIn(key, this.inExp.listExp);
    }

    @Override
    public void setRightVar(Object rightVar) {
    }

    @Override
    public void setNegFlag(boolean negFlag) {
    }

    public boolean isIn(DValue key, ListExp listExp) {
        for (Exp exp : listExp.valueL) {
            if (!this.doIsEqualTo(key, exp.strValue())) continue;
            return true;
        }
        return false;
    }

    private boolean doIsEqualTo(DValue dval, Object target) {
        String tmp = dval.asString();
        return tmp != null && tmp.equals(target);
    }
}

