/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import java.util.Date;
import org.delia.compiler.ast.StringExp;
import org.delia.core.DateFormatService;
import org.delia.core.DateFormatServiceImpl;
import org.delia.core.TimeZoneService;
import org.delia.core.TimeZoneServiceImpl;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluatorBase;
import org.delia.type.DValue;

public class DateOpEvaluator
extends OpEvaluatorBase {
    TimeZoneService tzSvc = new TimeZoneServiceImpl();
    private DateFormatService fmtSvc = new DateFormatServiceImpl(this.tzSvc);

    public DateOpEvaluator(OP op, String fieldName) {
        super(op, fieldName);
    }

    @Override
    protected boolean doMatch(Object left) {
        DValue dval = (DValue)left;
        Boolean b = this.checkNull(dval, this.rightVar);
        if (b != null) {
            return b;
        }
        Date n1 = this.getFieldValue(dval).asDate();
        String s = ((StringExp)this.rightVar).strValue();
        Date n2 = this.fmtSvc.parse(s);
        switch (this.op) {
            case LT: {
                return n1.compareTo(n2) < 0;
            }
            case LE: {
                return n1.compareTo(n2) <= 0;
            }
            case GT: {
                return n1.compareTo(n2) > 0;
            }
            case GE: {
                return n1.compareTo(n2) >= 0;
            }
            case EQ: {
                return n1.compareTo(n2) == 0;
            }
            case NEQ: {
                return n1.compareTo(n2) != 0;
            }
        }
        return false;
    }
}

